/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.struct;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SortedPreferentialArray {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$struct$SortedPreferentialArray == null ? (class$org$apache$jcs$utils$struct$SortedPreferentialArray = SortedPreferentialArray.class$("org.apache.jcs.utils.struct.SortedPreferentialArray")) : class$org$apache$jcs$utils$struct$SortedPreferentialArray));
    private boolean preferLarge = true;
    private int maxSize = 0;
    private int curSize = 0;
    private Comparable[] array;
    private int insertCnt = 0;
    static /* synthetic */ Class class$org$apache$jcs$utils$struct$SortedPreferentialArray;

    public SortedPreferentialArray(int maxSize) {
        this.maxSize = maxSize;
        this.array = new Comparable[maxSize];
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(Comparable obj) {
        if (this.curSize < this.maxSize) {
            this.insert(obj);
            return;
        }
        if (this.preferLarge) {
            Comparable sma = this.getSmallest();
            if (obj.compareTo(sma) > 0) {
                this.insert(obj);
                return;
            }
            if (!log.isDebugEnabled()) return;
            log.debug((Object)"New object is smaller than smallest");
            return;
        }
        if (this.preferLarge) return;
        Comparable lar = this.getLargest();
        if (obj.compareTo(lar) > 0) {
            if (!log.isDebugEnabled()) return;
            log.debug((Object)"New object is largerer than largest");
            return;
        }
        this.insert(obj);
    }

    public Comparable getLargest() {
        int num = this.curSize - 1;
        if (num < 0) {
            num = 0;
        }
        return this.array[num];
    }

    public Comparable getSmallest() {
        return this.array[0];
    }

    private void insert(Comparable obj) {
        try {
            int nLar = this.findNearestLargerOrEqualPosition(obj);
            if (log.isDebugEnabled()) {
                log.debug((Object)("nLar = " + nLar + " obj = " + obj));
            }
            if (nLar == this.curSize && this.curSize < this.maxSize) {
                this.array[nLar] = obj;
                ++this.curSize;
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.dumpArray());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Inserted object at the end of the array");
                }
                return;
            }
            boolean isFull = false;
            if (this.curSize == this.maxSize) {
                isFull = true;
            }
            if (this.preferLarge) {
                if (isFull) {
                    int pnt = nLar - 1;
                    int i = 0;
                    while (i < pnt) {
                        this.array[i] = this.array[i + 1];
                        ++i;
                    }
                    this.array[nLar - 1] = obj;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Inserted object at " + (nLar - 1)));
                    }
                } else {
                    int pnt = nLar;
                    int i = this.curSize;
                    while (i > pnt) {
                        this.array[i] = this.array[i - 1];
                        --i;
                    }
                    this.array[nLar] = obj;
                    ++this.curSize;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Inserted object at " + nLar));
                    }
                }
            } else {
                int pnt = nLar + 1;
                if (!isFull) {
                    pnt = nLar;
                }
                int i = this.curSize;
                while (i > pnt) {
                    this.array[i] = this.array[i - 1];
                    --i;
                }
                this.array[nLar] = obj;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inserted object at " + nLar));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)this.dumpArray());
            }
        }
        catch (Exception e) {
            log.error((Object)("Insertion problem" + this.dumpArray()), (Throwable)e);
        }
        ++this.insertCnt;
        if (this.insertCnt % 100 == 0 && log.isDebugEnabled()) {
            log.debug((Object)this.dumpArray());
        }
    }

    public void setPreferLarge(boolean pref) {
        this.preferLarge = pref;
    }

    public Comparable takeNearestLargerOrEqual(Comparable obj) {
        Comparable retVal = null;
        try {
            int pos = this.findNearestOccupiedLargerOrEqualPosition(obj);
            if (pos == -1) {
                return null;
            }
            try {
                retVal = this.array[pos];
                this.remove(pos);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("obj = " + obj + " || retVal = " + retVal));
            }
        }
        catch (Exception e) {
            log.error((Object)("Take problem" + this.dumpArray()), (Throwable)e);
        }
        return retVal;
    }

    private int findNearestOccupiedLargerOrEqualPosition(Comparable obj) {
        if (this.curSize == 0) {
            return -1;
        }
        int pos = this.findNearestLargerOrEqualPosition(obj);
        if (pos == this.curSize) {
            pos = obj.compareTo(this.array[pos - 1]) <= 0 ? --pos : -1;
        }
        return pos;
    }

    private int findNearestLargerOrEqualPosition(Comparable obj) {
        if (obj == null) {
            return -1;
        }
        if (this.curSize <= 0) {
            return 0;
        }
        int greaterPos = -1;
        int curPos = (this.curSize - 1) / 2;
        int prevPos = -1;
        try {
            boolean done = false;
            if (obj.compareTo(this.getSmallest()) <= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(obj + " is smaller than or equal to " + this.getSmallest()));
                }
                greaterPos = 0;
                done = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(obj + " is bigger than " + this.getSmallest()));
                }
                if (obj.compareTo(this.getLargest()) >= 0) {
                    if (this.curSize == this.maxSize) {
                        greaterPos = this.curSize - 1;
                        done = true;
                    } else {
                        greaterPos = this.curSize;
                        done = true;
                    }
                } else {
                    greaterPos = this.curSize - 1;
                }
            }
            while (!done) {
                int newPos;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\n curPos = " + curPos + "; greaterPos = " + greaterPos + "; prevpos = " + prevPos));
                }
                if (curPos == prevPos || curPos >= this.curSize) {
                    done = true;
                    break;
                }
                if (this.array[curPos].compareTo(obj) == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.array[curPos] + " is equal to " + obj));
                    }
                    greaterPos = curPos;
                    done = true;
                    break;
                }
                if (this.array[curPos].compareTo(obj) > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.array[curPos] + " is greater than " + obj));
                    }
                    greaterPos = curPos;
                    newPos = Math.min(curPos, (curPos + prevPos) / 2);
                    prevPos = curPos;
                    curPos = newPos;
                    continue;
                }
                if (this.array[curPos].compareTo(obj) >= 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.array[curPos] + " is less than " + obj));
                }
                if (greaterPos != -1 && greaterPos - curPos < 0) {
                    done = true;
                    break;
                }
                newPos = 0;
                if (prevPos > curPos) {
                    newPos = Math.min((curPos + prevPos) / 2, this.curSize);
                } else if (prevPos == -1) {
                    newPos = Math.min((this.curSize + curPos) / 2, this.curSize);
                }
                prevPos = curPos;
                curPos = newPos;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Greater Position is [" + greaterPos + "]" + " array[greaterPos] [" + this.array[greaterPos] + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)("\n curPos = " + curPos + "; greaterPos = " + greaterPos + "; prevpos = " + prevPos + " " + this.dumpArray()), (Throwable)e);
        }
        return greaterPos;
    }

    private void remove(int position) {
        try {
            int end = this.curSize - 1;
            int i = position;
            while (i < end) {
                this.array[i] = this.array[i + 1];
                ++i;
            }
            --this.curSize;
        }
        catch (Exception e) {
            log.error((Object)("Remove problem" + this.dumpArray()), (Throwable)e);
        }
    }

    private String dumpArray() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n ---------------------------");
        buf.append("\n curSize = " + this.curSize);
        buf.append("\n array.length = " + this.array.length);
        buf.append("\n ---------------------------");
        buf.append("\n Dump:");
        int i = 0;
        while (i < this.curSize) {
            buf.append("\n " + i + "=" + this.array[i]);
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        SortedPreferentialArray array = new SortedPreferentialArray(25);
        array.setPreferLarge(true);
        String[] elem = new String[]{"10", "11", "01", "02", "03", "04", "05", "08", "07", "06", "09", "12", "13", "15", "14", "20", "25", "29", "28", "16", "17", "96", "00", "72", "39", "55", "44", "26", "22", "59", "38", "16", "27"};
        int i = 0;
        while (i < elem.length) {
            array.add((Comparable)((Object)elem[i]));
            System.out.println(array.dumpArray());
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

