/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public abstract class SimpleNodeConstructor
extends Instruction {
    protected Expression select = null;

    public void setSelect(Expression expression, Configuration configuration) throws StaticError {
        this.select = expression;
        this.adoptChildExpression(expression);
    }

    public Expression getSelect() {
        return this.select;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        if (this.select != null) {
            this.select = this.select.simplify(staticContext);
        }
        return this;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public abstract void localTypeCheck(StaticContext var1, ItemType var2) throws XPathException;

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.localTypeCheck(staticContext, itemType);
        if (this.select != null) {
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            this.select = this.select.typeCheck(staticContext, itemType);
            if (!this.select.getItemType(typeHierarchy).isAtomicType()) {
                this.select = new Atomizer(this.select, staticContext.getConfiguration());
            }
            if (!typeHierarchy.isSubType(this.select.getItemType(typeHierarchy), BuiltInAtomicType.STRING)) {
                this.select = new AtomicSequenceConverter(this.select, BuiltInAtomicType.STRING);
            }
            this.adoptChildExpression(this.select);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.select != null) {
            this.select = this.select.optimize(optimizer, staticContext, itemType);
            this.adoptChildExpression(this.select);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.select);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.select == expression) {
            this.select = expression2;
            bl = true;
        }
        return bl;
    }

    public CharSequence expandChildren(XPathContext xPathContext) throws XPathException {
        Item item = this.select.evaluateItem(xPathContext);
        if (item == null) {
            return "";
        }
        return item.getStringValueCS();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string = this.select == null ? "" : this.select.evaluateAsString(xPathContext);
        string = this.checkContent(string, xPathContext);
        TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
        Orphan orphan = new Orphan(xPathContext.getConfiguration());
        orphan.setNodeKind((short)this.getItemType(typeHierarchy).getPrimitiveType());
        orphan.setStringValue(string);
        orphan.setNameCode(this.evaluateNameCode(xPathContext));
        return orphan;
    }

    protected String checkContent(String string, XPathContext xPathContext) throws DynamicError {
        return string;
    }

    public int evaluateNameCode(XPathContext xPathContext) throws XPathException, XPathException {
        return -1;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return SingletonIterator.makeIterator(this.evaluateItem(xPathContext));
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        if (this.select != null) {
            this.select.display(n, printStream, configuration);
        }
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.doPromotion(this.select, promotionOffer);
        }
        super.promoteInst(promotionOffer);
    }
}

