/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import net.sf.saxon.number.Numberer_en;

public class Numberer_fr
extends Numberer_en {
    private static final long serialVersionUID = -222104830008011842L;
    private static String[] frenchUnits = new String[]{"", "Un", "Deux", "Trois", "Quatre", "Cinq", "Six", "Sept", "Huit", "Neuf", "Dix", "Onze", "Douze", "Treize", "Quatorze", "Quinze", "Seize", "Dix-sept", "Dix-huit", "Dix-neuf"};
    private static String[] frenchTens = new String[]{"", "Dix", "Vingt", "Trente", "Quarante", "Cinquante", "Soixante", "Soixante", "Quatre-vingt", "Quatre-vingt"};
    private static String[] frenchOrdinalUnits = new String[]{"", "Premier", "Deuxi\u00e8me", "Troisi\u00e8me", "Quatri\u00e8me", "Cinqui\u00e8me", "Sixi\u00e8me", "Septi\u00e8me", "Huiti\u00e8me", "Neuvi\u00e8me", "Dixi\u00e8me", "Onzi\u00e8me", "Douzi\u00e8me", "Treizi\u00e8me", "Quatorzi\u00e8me", "Quinzi\u00e8me", "Seizi\u00e8me", "Dix-septi\u00e8me", "Dix-huiti\u00e8me", "Dix-neuvi\u00e8me"};
    private static String[] frenchOrdinalTens = new String[]{"", "Dixi\u00e8me", "Vingti\u00e8me", "Trenti\u00e8me", "Quaranti\u00e8me", "Cinquanti\u00e8me", "Soixanti\u00e8me", "Soixante", "Quatre-vingti\u00e8me", "Quatre-vingt"};
    private static String[] frenchDays = new String[]{"Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi"};
    private static String[] frenchMonths = new String[]{"Janvier", "F\u00e9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\u00fbt", "Septembre", "Octobre", "Novembre", "D\u00e9cembre"};

    protected String ordinalSuffix(String string, long l) {
        if (l != 1L) {
            return "e";
        }
        return "er";
    }

    public String toWords(long l) {
        return this.toWords(l, true);
    }

    public String toWords(long l, int n) {
        String string = this.toWords(l);
        if (n == 0) {
            return string.toUpperCase();
        }
        if (n == 1) {
            return string.toLowerCase();
        }
        return string;
    }

    private String toWords(long l, boolean bl) {
        if (l == 0L) {
            return "Z\u00e9ro";
        }
        if (l >= 1000000000000000000L) {
            long l2 = l % 1000000000000000000L;
            long l3 = l / 1000000000000000000L;
            String string = l3 == 1L ? "Un" : this.toWords(l3, true);
            return string + " quintillion" + (l3 > 1L ? "s" : "") + (l2 == 0L ? "" : " " + this.toWords(l2, 1, bl));
        }
        if (l >= 1000000000000000L) {
            long l4 = l % 1000000000000000L;
            long l5 = l / 1000000000000000L;
            String string = l5 == 1L ? "Un" : this.toWords(l5, true);
            return string + " quatrillion" + (l5 > 1L ? "s" : "") + (l4 == 0L ? "" : " " + this.toWords(l4, 1, bl));
        }
        if (l >= 1000000000000L) {
            long l6 = l % 1000000000000L;
            long l7 = l / 1000000000000L;
            String string = l7 == 1L ? "Un" : this.toWords(l7, true);
            return string + " trillion" + (l7 > 1L ? "s" : "") + (l6 == 0L ? "" : " " + this.toWords(l6, 1, bl));
        }
        if (l >= 1000000000L) {
            long l8 = l % 1000000000L;
            long l9 = l / 1000000000L;
            String string = l9 == 1L ? "Un" : this.toWords(l9, true);
            return string + " milliard" + (l9 > 1L ? "s" : "") + (l8 == 0L ? "" : " " + this.toWords(l8, 1, bl));
        }
        if (l >= 1000000L) {
            long l10 = l % 1000000L;
            long l11 = l / 1000000L;
            String string = l11 == 1L ? "Un" : this.toWords(l11, true);
            return string + " million" + (l11 > 1L ? "s" : "") + (l10 == 0L ? "" : " " + this.toWords(l10, 1, bl));
        }
        if (l >= 1000L) {
            long l12 = l % 1000L;
            long l13 = l / 1000L;
            String string = l13 == 1L ? "" : this.toWords(l13, false);
            return string + (l13 == 1L ? "Mille" : " mille") + (l12 == 0L ? "" : " " + this.toWords(l12, 1, bl));
        }
        if (l >= 100L) {
            long l14 = l % 100L;
            long l15 = l / 100L;
            String string = l15 == 1L ? "" : this.toWords(l15, false);
            return string + (l15 == 1L ? "Cent" : " cent") + (l14 == 0L && l15 > 1L && bl ? "s" : (l14 != 0L ? " " + this.toWords(l14, 1, bl) : ""));
        }
        if (l < 20L) {
            return frenchUnits[(int)l];
        }
        int n = (int)(l % 10L);
        int n2 = (int)l / 10;
        if (n2 == 7 || n2 == 9) {
            n += 10;
        }
        String string = n == 1 || n == 11 ? (n2 == 8 || n2 == 9 ? "-" : " et ") : "-";
        return frenchTens[n2] + (n == 0 ? (n2 == 8 && bl ? "s" : "") : string) + (n2 == 0 ? frenchUnits[n] : frenchUnits[n].toLowerCase());
    }

    private String toWords(long l, int n, boolean bl) {
        String string = this.toWords(l, bl);
        if (n == 0) {
            return string.toUpperCase();
        }
        if (n == 1) {
            return string.toLowerCase();
        }
        return string;
    }

    public String toOrdinalWords(String string, long l, int n) {
        String string2;
        if (l < 20L) {
            string2 = l == 0L ? "Z\u00e9roi\u00e8me" : frenchOrdinalUnits[(int)l];
        } else if (l < 100L) {
            long l2 = l % 10L;
            long l3 = l / 10L;
            if (l3 == 7L || l3 == 9L) {
                --l3;
                l2 += 10L;
            }
            if (l2 == 0L) {
                string2 = frenchOrdinalTens[(int)l3];
            } else {
                String string3 = l2 == 1L || l2 == 11L ? (l3 == 8L ? "-" : " et ") : "-";
                String string4 = this.toWords(l3 * 10L);
                if (l3 == 8L) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                String string5 = string4 + string3;
                string2 = string5 + (l2 == 1L ? "uni\u00e8me" : this.toOrdinalWords("", l2, 1));
            }
        } else {
            String string6 = "i\u00e8me";
            long l4 = l % 100L;
            long l5 = l / 100L;
            if (l5 == 70L || l5 == 90L) {
                l5 -= 10L;
                l4 += 100L;
            }
            String string7 = this.toWords(l5 * 100L, false);
            if (l5 % 10000L == 0L) {
                string7 = string7.replaceFirst("Un ", "");
            }
            if ((string7.endsWith("mille") || string7.endsWith("Mille")) && l4 == 0L) {
                string7 = string7.substring(0, string7.length() - 1);
            } else if (string7.endsWith("illions") || string7.endsWith("illiards")) {
                string7 = string7.substring(0, string7.length() - 1);
            }
            string2 = string7 + (l4 == 0L ? string6 : " " + (l4 == 1L ? "uni\u00e8me" : this.toOrdinalWords("", l4, 1)));
        }
        if (n == 0) {
            return string2.toUpperCase();
        }
        if (n == 1) {
            return string2.toLowerCase();
        }
        return string2;
    }

    public String monthName(int n, int n2, int n3) {
        String string = frenchMonths[n - 1];
        if (n3 < 3) {
            n3 = 3;
        }
        if (string.length() > n3) {
            string = string.substring(0, n3);
        }
        while (string.length() < n2) {
            string = string + " ";
        }
        return string;
    }

    public String dayName(int n, int n2, int n3) {
        String string = frenchDays[n - 1];
        if (n3 < 3) {
            n3 = 3;
        }
        if (string.length() > n3) {
            string = string.substring(0, n3);
        }
        while (string.length() < n2) {
            string = string + " ";
        }
        return string;
    }
}

