/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Whitespace;

public final class YearMonthDurationValue
extends DurationValue
implements Comparable {
    private YearMonthDurationValue() {
        this.typeLabel = BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    public YearMonthDurationValue(CharSequence charSequence) throws XPathException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)Whitespace.trimWhitespace(charSequence)).toString(), "-+PYM", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ("+".equals(string = (String)stringTokenizer.nextElement())) {
                this.badDuration("+ sign not allowed in a duration", charSequence);
            } else if ("-".equals(string)) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!"P".equals(string)) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n2 = 0;
            block6: while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                int n3 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'Y': {
                        if (n2 > 0) {
                            this.badDuration("Y is out of sequence", charSequence);
                        }
                        this.years = n3;
                        ++n;
                        n2 = 1;
                        continue block6;
                    }
                    case 'M': {
                        if (n2 == 0 || n2 == 1) {
                            this.months = n3;
                            ++n;
                            n2 = 2;
                            continue block6;
                        }
                        this.badDuration("M is out of sequence", charSequence);
                    }
                }
                this.badDuration("misplaced " + c, charSequence);
            }
            if (n == 0) {
                this.badDuration("Duration specifies no components", charSequence);
            }
            this.normalize();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric component", charSequence);
        }
        this.typeLabel = BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    public AtomicValue copy(AtomicType atomicType) {
        YearMonthDurationValue yearMonthDurationValue = YearMonthDurationValue.fromMonths(this.getLengthInMonths());
        yearMonthDurationValue.typeLabel = atomicType;
        return yearMonthDurationValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    public CharSequence getStringValueCS() {
        int n = this.years * 12 + this.months;
        int n2 = n / 12;
        int n3 = n % 12;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append('P');
        if (n2 != 0) {
            fastStringBuffer.append(n2 + "Y");
        }
        if (n3 != 0 || n2 == 0) {
            fastStringBuffer.append(n3 + "M");
        }
        return fastStringBuffer;
    }

    public void normalize() {
        if (this.months >= 12) {
            this.years += this.months / 12;
            this.months %= 12;
        }
        this.normalizeZeroDuration();
        this.normalized = true;
    }

    public int getLengthInMonths() {
        return (this.years * 12 + this.months) * (this.negative ? -1 : 1);
    }

    public static YearMonthDurationValue fromMonths(int n) {
        YearMonthDurationValue yearMonthDurationValue = new YearMonthDurationValue();
        yearMonthDurationValue.negative = n < 0;
        yearMonthDurationValue.months = n < 0 ? -n : n;
        yearMonthDurationValue.normalize();
        return yearMonthDurationValue;
    }

    public DurationValue multiply(double d) throws XPathException {
        if (Double.isNaN(d)) {
            DynamicError dynamicError = new DynamicError("Cannot multiply/divide a duration by NaN");
            dynamicError.setErrorCode("FOCA0005");
            throw dynamicError;
        }
        double d2 = this.getLengthInMonths();
        double d3 = d * d2;
        if (Double.isInfinite(d3) || d3 > 2.147483647E9 || d3 < -2.147483648E9) {
            DynamicError dynamicError = new DynamicError("Overflow when multiplying/dividing a duration by a number");
            dynamicError.setErrorCode("FODT0002");
            throw dynamicError;
        }
        return YearMonthDurationValue.fromMonths((int)Math.round(d3));
    }

    public DecimalValue divide(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof YearMonthDurationValue) {
            BigDecimal bigDecimal = BigDecimal.valueOf(this.getLengthInMonths());
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((YearMonthDurationValue)durationValue).getLengthInMonths());
            if (bigDecimal2.signum() == 0) {
                DynamicError dynamicError = new DynamicError("Divide by zero (durations)");
                dynamicError.setErrorCode("FOAR0001");
                throw dynamicError;
            }
            return new DecimalValue(bigDecimal.divide(bigDecimal2, 20, 6));
        }
        DynamicError dynamicError = new DynamicError("Cannot divide two durations of different type");
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public DurationValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() + ((YearMonthDurationValue)durationValue).getLengthInMonths());
        }
        DynamicError dynamicError = new DynamicError("Cannot add two durations of different type");
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public DurationValue subtract(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() - ((YearMonthDurationValue)durationValue).getLengthInMonths());
        }
        DynamicError dynamicError = new DynamicError("Cannot subtract two durations of different type");
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public DurationValue negate() {
        return YearMonthDurationValue.fromMonths(-this.getLengthInMonths());
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(DurationValue.class)) {
            return this;
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Object.class) {
            return this.getStringValue();
        }
        DynamicError dynamicError = new DynamicError("Conversion of yearMonthDuration to " + clazz.getName() + " is not supported");
        dynamicError.setErrorCode("SXJE0008");
        throw dynamicError;
    }

    public int compareTo(Object object) {
        if (object instanceof YearMonthDurationValue) {
            return this.getLengthInMonths() - ((YearMonthDurationValue)object).getLengthInMonths();
        }
        if (object instanceof DurationValue.DurationValueOrderingKey) {
            return DurationValue.getSchemaComparable(this).compareTo(object);
        }
        throw new ClassCastException("Cannot compare a yearMonthDuration to an object of class " + object.getClass());
    }

    public Comparable getSchemaComparable() {
        return this;
    }

    public Comparable getXPathComparable() {
        return this;
    }
}

