/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

public class XSLTExtension {
    public static String escapeJavaString(String string) {
        char[] chr = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        block8: for (int i = 0; i < chr.length; ++i) {
            char c = chr[i];
            switch (c) {
                case '\t': {
                    buffer.append("\\t");
                    continue block8;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block8;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block8;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block8;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block8;
                }
                case '\"': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block8;
                }
                default: {
                    if (' ' <= c && c <= '\u007f') {
                        buffer.append(c);
                        continue block8;
                    }
                    buffer.append("\\u");
                    buffer.append(XSLTExtension.int2digit(c >> 12));
                    buffer.append(XSLTExtension.int2digit(c >> 8));
                    buffer.append(XSLTExtension.int2digit(c >> 4));
                    buffer.append(XSLTExtension.int2digit(c));
                }
            }
        }
        String encoded = buffer.toString();
        return encoded;
    }

    public static String escapeString(String string) {
        char[] chr = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < chr.length; ++i) {
            char c = chr[i];
            if (c <= '\u007f') {
                buffer.append(c);
                continue;
            }
            buffer.append("\\u");
            buffer.append(XSLTExtension.int2digit(c >> 12));
            buffer.append(XSLTExtension.int2digit(c >> 8));
            buffer.append(XSLTExtension.int2digit(c >> 4));
            buffer.append(XSLTExtension.int2digit(c));
        }
        String encoded = buffer.toString();
        return encoded;
    }

    private static char int2digit(int x) {
        if ((x &= 0xF) <= 9) {
            return (char)(x + 48);
        }
        return (char)(x - 10 + 65);
    }

    public String escape(String string) {
        return XSLTExtension.escapeString(string);
    }

    public String escapeJava(String string) {
        return XSLTExtension.escapeJavaString(string);
    }

    public String prefix(String string) {
        int i;
        char[] chr = string.toCharArray();
        for (i = 0; i < chr.length && chr[i] != '\n' && chr[i] != '\r'; ++i) {
        }
        if (i == chr.length) {
            return "";
        }
        int j = 0;
        while (i < chr.length) {
            if (chr[i] == '\n' || chr[i] == '\r') {
                j = 0;
            } else {
                if (!Character.isSpaceChar(chr[i])) break;
                ++j;
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < j; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public String suffix(String string) {
        char[] chr = string.toCharArray();
        int j = 0;
        for (int i = chr.length - 1; i >= 0 && chr[i] != '\n' && chr[i] != '\r'; --i) {
            if (!Character.isSpaceChar(chr[i])) {
                return "";
            }
            ++j;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < j; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

