/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.cocoon.components.language.markup.xsp.XSPObjectHelper;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.commons.lang.BooleanUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XSPCookieHelper
extends XSPObjectHelper {
    private static final String URI = "http://apache.org/xsp/cookie/2.0";
    private static final String PREFIX = "xsp-cookie";

    public static void addCookie(Map objectModel, String name, String value, String comment, String domain, int maxage, String path, String secure, int version) {
        Response response = ObjectModelHelper.getResponse((Map)objectModel);
        Cookie cookieToSet = response.createCookie(name, value);
        if (comment.trim().length() > 0) {
            cookieToSet.setComment(comment);
        }
        if (domain.trim().length() > 0) {
            cookieToSet.setDomain(domain);
        }
        if (maxage > 0) {
            cookieToSet.setMaxAge(maxage);
        }
        if (path.trim().length() > 0) {
            cookieToSet.setPath("/");
        }
        cookieToSet.setSecure(BooleanUtils.toBoolean((String)secure));
        cookieToSet.setVersion(version);
        response.addCookie(cookieToSet);
    }

    public static Cookie[] getCookies(Map objectModel) {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        return request.getCookies();
    }

    public static void getCookies(Map objectModel, ContentHandler contentHandler) throws SAXException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            int count = 0;
            String tempStr = null;
            Hashtable<String, String> nodeTable = new Hashtable<String, String>();
            XSPObjectHelper.start(URI, PREFIX, contentHandler, "cookies");
            for (count = 0; count < cookies.length; ++count) {
                XSPObjectHelper.start(URI, PREFIX, contentHandler, "cookie");
                tempStr = XSPCookieHelper.getName(objectModel, null, count);
                if (tempStr != null) {
                    nodeTable.put("name", tempStr);
                }
                if ((tempStr = XSPCookieHelper.getValue(objectModel, null, count)) != null) {
                    nodeTable.put("value", tempStr);
                }
                if ((tempStr = XSPCookieHelper.getComment(objectModel, null, count)) != null) {
                    nodeTable.put("comment", tempStr);
                }
                if ((tempStr = XSPCookieHelper.getDomain(objectModel, null, count)) != null) {
                    nodeTable.put("domain", tempStr);
                }
                if ((tempStr = XSPCookieHelper.getMaxAge(objectModel, null, count)) != null) {
                    nodeTable.put("maxage", tempStr);
                }
                if ((tempStr = XSPCookieHelper.getPath(objectModel, null, count)) != null) {
                    nodeTable.put("path", tempStr);
                }
                if ((tempStr = XSPCookieHelper.getSecure(objectModel, null, count)) != null) {
                    nodeTable.put("secure", tempStr);
                }
                if ((tempStr = XSPCookieHelper.getVersion(objectModel, null, count)) != null) {
                    nodeTable.put("version", tempStr);
                }
                Enumeration keys = nodeTable.keys();
                while (keys.hasMoreElements()) {
                    String nodeName = (String)keys.nextElement();
                    String nodeValue = (String)nodeTable.get(nodeName);
                    XSPObjectHelper.elementData(URI, PREFIX, contentHandler, nodeName, nodeValue);
                }
                XSPObjectHelper.end(URI, PREFIX, contentHandler, "cookie");
            }
            XSPObjectHelper.end(URI, PREFIX, contentHandler, "cookies");
        }
    }

    public static Cookie getCookie(Map objectModel, String cookieName, int cookieIndex) {
        boolean retrieveByName = false;
        boolean retrieveByIndex = false;
        boolean matchFound = false;
        int count = 0;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Cookie currentCookie = null;
        if (cookieName != null) {
            retrieveByName = true;
        } else if (cookieIndex >= 0) {
            retrieveByIndex = true;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null && retrieveByName) {
            for (count = 0; count < cookies.length; ++count) {
                currentCookie = cookies[count];
                if (!currentCookie.getName().equals(cookieName)) continue;
                matchFound = true;
                break;
            }
        } else if (cookies != null && retrieveByIndex && cookies.length > cookieIndex) {
            currentCookie = cookies[cookieIndex];
            matchFound = true;
        }
        if (matchFound) {
            return currentCookie;
        }
        return null;
    }

    public static void getCookie(Map objectModel, String cookieName, int cookieIndex, ContentHandler contentHandler) throws SAXException {
        boolean retrieveByName = false;
        boolean retrieveByIndex = false;
        String tempStr = null;
        Hashtable<String, String> nodeTable = new Hashtable<String, String>();
        if (cookieName != null) {
            retrieveByName = true;
        } else if (cookieIndex >= 0) {
            retrieveByIndex = true;
        }
        if (retrieveByName || retrieveByIndex) {
            tempStr = XSPCookieHelper.getName(objectModel, cookieName, cookieIndex);
        }
        if (tempStr != null) {
            XSPObjectHelper.start(URI, PREFIX, contentHandler, "cookie");
            nodeTable.put("name", tempStr);
            tempStr = XSPCookieHelper.getValue(objectModel, cookieName, cookieIndex);
            if (tempStr != null) {
                nodeTable.put("value", tempStr);
            }
            if ((tempStr = XSPCookieHelper.getComment(objectModel, cookieName, cookieIndex)) != null) {
                nodeTable.put("comment", tempStr);
            }
            if ((tempStr = XSPCookieHelper.getDomain(objectModel, cookieName, cookieIndex)) != null) {
                nodeTable.put("domain", tempStr);
            }
            if ((tempStr = XSPCookieHelper.getMaxAge(objectModel, cookieName, cookieIndex)) != null) {
                nodeTable.put("maxage", tempStr);
            }
            if ((tempStr = XSPCookieHelper.getPath(objectModel, cookieName, cookieIndex)) != null) {
                nodeTable.put("path", tempStr);
            }
            if ((tempStr = XSPCookieHelper.getSecure(objectModel, cookieName, cookieIndex)) != null) {
                nodeTable.put("secure", tempStr);
            }
            if ((tempStr = XSPCookieHelper.getVersion(objectModel, cookieName, cookieIndex)) != null) {
                nodeTable.put("version", tempStr);
            }
            Enumeration keys = nodeTable.keys();
            while (keys.hasMoreElements()) {
                String nodeName = (String)keys.nextElement();
                String nodeValue = (String)nodeTable.get(nodeName);
                XSPObjectHelper.elementData(URI, PREFIX, contentHandler, nodeName, nodeValue);
            }
            XSPObjectHelper.end(URI, PREFIX, contentHandler, "cookie");
        }
    }

    public static String getComment(Map objectModel, String cookieName, int cookieIndex) {
        return XSPCookieHelper.returnCookieProperty(objectModel, cookieName, cookieIndex, "C");
    }

    public static String getDomain(Map objectModel, String cookieName, int cookieIndex) {
        return XSPCookieHelper.returnCookieProperty(objectModel, cookieName, cookieIndex, "D");
    }

    public static String getMaxAge(Map objectModel, String cookieName, int cookieIndex) {
        return XSPCookieHelper.returnCookieProperty(objectModel, cookieName, cookieIndex, "M");
    }

    public static String getName(Map objectModel, String cookieName, int cookieIndex) {
        return XSPCookieHelper.returnCookieProperty(objectModel, cookieName, cookieIndex, "N");
    }

    public static String getPath(Map objectModel, String cookieName, int cookieIndex) {
        return XSPCookieHelper.returnCookieProperty(objectModel, cookieName, cookieIndex, "P");
    }

    public static String getSecure(Map objectModel, String cookieName, int cookieIndex) {
        return XSPCookieHelper.returnCookieProperty(objectModel, cookieName, cookieIndex, "S");
    }

    public static String getValue(Map objectModel, String cookieName, int cookieIndex) {
        return XSPCookieHelper.returnCookieProperty(objectModel, cookieName, cookieIndex, "V");
    }

    public static String getVersion(Map objectModel, String cookieName, int cookieIndex) {
        return XSPCookieHelper.returnCookieProperty(objectModel, cookieName, cookieIndex, "Ve");
    }

    private static String returnCookieProperty(Map objectModel, String cookieName, int cookieIndex, String propertyPrefix) {
        Cookie currentCookie = XSPCookieHelper.getCookie(objectModel, cookieName, cookieIndex);
        String returnValue = null;
        if (currentCookie != null) {
            if (propertyPrefix.equals("C")) {
                returnValue = currentCookie.getComment();
            } else if (propertyPrefix.equals("D")) {
                returnValue = currentCookie.getDomain();
            } else if (propertyPrefix.equals("M")) {
                returnValue = Integer.toString(currentCookie.getMaxAge());
            } else if (propertyPrefix.equals("N")) {
                returnValue = currentCookie.getName();
            } else if (propertyPrefix.equals("P")) {
                returnValue = currentCookie.getPath();
            } else if (propertyPrefix.equals("S")) {
                returnValue = String.valueOf(currentCookie.getSecure());
            } else if (propertyPrefix.equals("V")) {
                returnValue = currentCookie.getValue();
            } else if (propertyPrefix.equals("Ve")) {
                returnValue = Integer.toString(currentCookie.getVersion());
            }
        }
        return returnValue;
    }
}

