/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptor;
import org.apache.excalibur.instrument.manager.http.AbstractHTMLHandler;
import org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector;

public class HTMLInstrumentManagerHandler
extends AbstractHTMLHandler {
    private InstrumentManagerHTTPConnector m_connector;

    public HTMLInstrumentManagerHandler(DefaultInstrumentManager manager, InstrumentManagerHTTPConnector connector) {
        super("/instrument-manager.html", manager);
        this.m_connector = connector;
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        long oldMemory = this.getLongParameter(parameters, "oldMemory", 0L);
        long newMemory = this.getLongParameter(parameters, "newMemory", 0L);
        String gcLabel = "<a href='gc.html'>Perform Garbage Collection</a>";
        if (oldMemory != 0L && newMemory != 0L) {
            gcLabel = gcLabel + " (Freed: " + (oldMemory - newMemory) + "bytes.  " + "Now " + newMemory + " bytes.";
        }
        out.println("<html>");
        out.println("<head><title>" + this.getInstrumentManager().getDescription() + "</title></head>");
        out.println("<body>");
        this.breadCrumbs(out, false);
        out.println("<h2>Instrument Manager</h2>");
        this.startTable(out);
        this.tableRow(out, 0, "Name", this.getInstrumentManager().getName());
        this.tableRow(out, 0, "Description", this.getInstrumentManager().getDescription());
        if (!this.m_connector.isReadOnly()) {
            this.tableRow(out, 0, "GC", gcLabel);
        }
        this.endTable(out);
        InstrumentableDescriptor[] instrumentables = this.getInstrumentManager().getInstrumentableDescriptors();
        if (instrumentables.length > 0) {
            out.println("<h2>Instrumentables</h2>");
            this.outputInstrumentables(out, instrumentables);
        }
        this.footer(out);
        out.println("</body>");
        out.println("</html>");
    }
}

