/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.ValueInstrument;
import org.apache.excalibur.instrument.manager.http.server.AbstractLogEnabledInstrumentableStartable;

abstract class AbstractSocketServer
extends AbstractLogEnabledInstrumentableStartable {
    private Object m_semaphore = new Object();
    private int m_port;
    private int m_backlog = 50;
    private InetAddress m_bindAddr;
    private int m_soTimeout = 30000;
    private long m_shutdownTimeout = 5000L;
    private boolean m_started;
    private ServerSocket m_serverSocket;
    private List m_openSockets = new ArrayList();
    private CounterInstrument m_instrumentConnects;
    private ValueInstrument m_instrumentOpenSockets;
    private CounterInstrument m_instrumentDisconnects;

    public AbstractSocketServer(int port, InetAddress bindAddress) {
        this.m_port = port;
        this.m_bindAddr = bindAddress;
        this.m_instrumentConnects = new CounterInstrument("connects");
        this.m_instrumentOpenSockets = new ValueInstrument("open-sockets");
        this.m_instrumentDisconnects = new CounterInstrument("disconnects");
        this.addInstrument((Instrument)this.m_instrumentConnects);
        this.addInstrument((Instrument)this.m_instrumentOpenSockets);
        this.addInstrument((Instrument)this.m_instrumentDisconnects);
    }

    public void start() throws Exception {
        try {
            this.m_serverSocket = new ServerSocket(this.m_port, this.m_backlog, this.m_bindAddr);
        }
        catch (IOException e) {
            String msg = "Unable to bind to port " + this.m_port + ": " + e.getMessage();
            throw new BindException(msg);
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRunner() throws Exception {
        ServerSocket serverSocket = this.m_serverSocket;
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException e) {
                this.getLogger().debug("Unable to close the server socket.", (Throwable)e);
            }
        }
        Object object = this.m_semaphore;
        synchronized (object) {
            int size;
            long start = System.currentTimeMillis();
            boolean closed = false;
            int lastSize = 0;
            while ((size = this.m_openSockets.size()) > 0) {
                if (lastSize != size) {
                    this.getLogger().debug("Waiting until " + size + " open sockets have been closed.");
                    lastSize = size;
                }
                try {
                    this.m_semaphore.wait(250L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                if (closed || this.m_shutdownTimeout <= 0L || now - start < this.m_shutdownTimeout) continue;
                this.getLogger().debug("Closing " + this.m_openSockets.size() + " open sockets that did " + "not exit on their own.");
                Iterator iter = this.m_openSockets.iterator();
                while (iter.hasNext()) {
                    Socket socket = (Socket)iter.next();
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        this.getLogger().debug("Problem closing socket.", (Throwable)e);
                    }
                }
                closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runner() {
        this.m_started = true;
        int workerId = 1;
        try {
            while (!this.isStopping()) {
                try {
                    int openSockets;
                    this.getLogger().debug("Listen for a connection...");
                    final Socket socket = this.m_serverSocket.accept();
                    socket.setSoTimeout(this.m_soTimeout);
                    socket.setTcpNoDelay(true);
                    if (this.getLogger().isDebugEnabled()) {
                        String remoteIP = socket.getInetAddress().getHostAddress();
                        this.getLogger().debug("Accepted a connection from " + remoteIP);
                    }
                    Object object = this.m_semaphore;
                    synchronized (object) {
                        this.m_openSockets.add(socket);
                        openSockets = this.m_openSockets.size();
                        this.getLogger().debug("Open sockets: " + openSockets);
                    }
                    this.m_instrumentConnects.increment();
                    this.m_instrumentOpenSockets.setValue(openSockets);
                    Thread worker = new Thread("socketWorker." + workerId++){

                        public void run() {
                            AbstractSocketServer.this.handleSocketInner(socket);
                        }
                    };
                    worker.start();
                }
                catch (Throwable t) {
                    if (this.isStopping() && (t instanceof InterruptedException || t instanceof SocketException || t instanceof InterruptedIOException)) continue;
                    this.getLogger().error("Encountered an unexpected error, continuing.", t);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                this.m_serverSocket.close();
                throw throwable;
            }
            catch (IOException e) {
                this.getLogger().debug("Unable to close the server socket.", (Throwable)e);
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            this.getLogger().debug("Unable to close the server socket.", (Throwable)e);
            return;
        }
        this.m_serverSocket.close();
    }

    protected abstract void handleSocket(Socket var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSocketInner(Socket socket) {
        try {
            int openSockets2;
            Object object;
            try {
                this.handleSocket(socket);
                Object var3_2 = null;
                object = this.m_semaphore;
            }
            catch (Throwable throwable) {
                int openSockets2;
                Object var3_3 = null;
                Object object2 = this.m_semaphore;
                synchronized (object2) {
                    this.m_openSockets.remove(socket);
                    openSockets2 = this.m_openSockets.size();
                    this.getLogger().debug("Open sockets: " + openSockets2);
                    this.m_semaphore.notify();
                }
                this.m_instrumentOpenSockets.setValue(openSockets2);
                this.m_instrumentDisconnects.increment();
                socket.close();
                throw throwable;
            }
            synchronized (object) {
                this.m_openSockets.remove(socket);
                openSockets2 = this.m_openSockets.size();
                this.getLogger().debug("Open sockets: " + openSockets2);
                this.m_semaphore.notify();
            }
            this.m_instrumentOpenSockets.setValue(openSockets2);
            this.m_instrumentDisconnects.increment();
            socket.close();
            {
            }
        }
        catch (Throwable t) {
            this.getLogger().error("Encountered an error while handling socket: " + socket, t);
        }
    }

    protected int getSoTimeout() {
        return this.m_soTimeout;
    }
}

