/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.validationruleimpl;

import java.math.BigDecimal;
import org.apache.cocoon.forms.datatype.validationruleimpl.AbstractValidationRule;
import org.apache.cocoon.forms.formmodel.CannotYetResolveWarning;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.outerj.expression.Expression;
import org.outerj.expression.ExpressionContext;

public class LengthValidationRule
extends AbstractValidationRule {
    private Expression exactExpr;
    private Expression minExpr;
    private Expression maxExpr;
    static /* synthetic */ Class class$java$lang$String;

    public void setExactExpr(Expression exactExpr) {
        this.exactExpr = exactExpr;
    }

    public void setMinExpr(Expression minExpr) {
        this.minExpr = minExpr;
    }

    public void setMaxExpr(Expression maxExpr) {
        this.maxExpr = maxExpr;
    }

    public ValidationError validate(Object value, ExpressionContext expressionContext) {
        String string = (String)value;
        if (this.exactExpr != null) {
            Object result = this.evaluateNumeric(this.exactExpr, expressionContext, "exact", "length");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int length = ((BigDecimal)result).intValue();
            if (string.length() != length) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.string.exact-length", new String[]{String.valueOf(length)}, "forms"));
            }
            return null;
        }
        if (this.minExpr != null && this.maxExpr != null) {
            Object result = this.evaluateNumeric(this.minExpr, expressionContext, "min", "length");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int minLength = ((BigDecimal)result).intValue();
            result = this.evaluateNumeric(this.maxExpr, expressionContext, "max", "length");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int maxLength = ((BigDecimal)result).intValue();
            if (string.length() < minLength || string.length() > maxLength) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.string.range-length", new String[]{String.valueOf(minLength), String.valueOf(maxLength)}, "forms"));
            }
            return null;
        }
        if (this.minExpr != null) {
            Object result = this.evaluateNumeric(this.minExpr, expressionContext, "min", "length");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int length = ((BigDecimal)result).intValue();
            if (string.length() < length) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.string.min-length", new String[]{String.valueOf(length)}, "forms"));
            }
            return null;
        }
        if (this.maxExpr != null) {
            Object result = this.evaluateNumeric(this.maxExpr, expressionContext, "max", "length");
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            int length = ((BigDecimal)result).intValue();
            if (string.length() > length) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.string.max-length", new String[]{String.valueOf(length)}, "forms"));
            }
            return null;
        }
        return null;
    }

    public boolean supportsType(Class clazz, boolean arrayType) {
        return clazz.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = LengthValidationRule.class$("java.lang.String")) : class$java$lang$String) && !arrayType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

