/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.sax;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentHandlerWrapper
implements ContentHandler,
LexicalHandler {
    private ContentHandler m_contentHandler;
    private LexicalHandler m_lexicalHandler;

    public ContentHandlerWrapper() {
    }

    public ContentHandlerWrapper(ContentHandler contentHandler) {
        this.setContentHandler(contentHandler);
    }

    public ContentHandlerWrapper(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        this.setContentHandler(contentHandler);
        this.setLexicalHandler(lexicalHandler);
    }

    public void setContentHandler(ContentHandler contentHandler) throws IllegalStateException {
        if (null != this.m_contentHandler) {
            throw new IllegalStateException();
        }
        this.m_contentHandler = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) throws IllegalStateException {
        if (null != this.m_lexicalHandler) {
            throw new IllegalStateException();
        }
        this.m_lexicalHandler = lexicalHandler;
    }

    public void setDocumentLocator(Locator locator) {
        if (null == this.m_contentHandler) {
            return;
        }
        this.m_contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        if (null == this.m_contentHandler) {
            String message = "ContentHandler not set";
            throw new SAXException("ContentHandler not set");
        }
        this.m_contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.m_contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (null == this.m_contentHandler) {
            String message = "ContentHandler not set";
            throw new SAXException("ContentHandler not set");
        }
        this.m_contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.m_contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.m_contentHandler.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.m_contentHandler.endElement(uri, loc, raw);
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.m_contentHandler.characters(ch, start, len);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this.m_contentHandler.ignorableWhitespace(ch, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.m_contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.m_contentHandler.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.comment(ch, start, len);
        }
    }
}

