/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/

package fr.gouv.culture.sdx.search.lucene.filter;

import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.lucene.index.IndexReader;

import java.util.BitSet;

/*
 *	Interface pour les classes permettant de definir des filtres.
 *
 *	Essentiellement, cette interface definit une methode permettant
 *	de retourner un BitSet des documents admis en fonction de
 *	ce critere.
 */

/**Interface for the classes which define filters.
 *
 * Primarily, this interface defines a method making it
 * possible to turn over BitSet of the documents admitted
 * according to this criteria.
 *
 */
public interface FilterCriteria extends XMLizable {

    /**
     *	Applies the criteria and turns over the documents which satisfy it
     *
     *	@param	r		The reader of the index.
     */
    public BitSet bits(IndexReader r);

}

