/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.utils.AbstractSdxObject;

public abstract class AbstractResponse extends AbstractSdxObject {

    public static final int HPP_ALL_HITS = -1;
    /** The default number of documents to show per page. */
    public static final int HITS_PER_PAGE = 20;
    /** The maximum number of pages*/
    protected int _nbPages;
    /** The number of results to show per page. */
    protected int _hitsPerPage = HITS_PER_PAGE;//Defaulted
    /** The indices where the results come from. */
    protected SearchLocations _searchLocations;
    protected int _count = 0;


    public int getHitsPerPage() {
        return _hitsPerPage;
    }

    public int getNbPages() {
        return _nbPages;
    }

    public SearchLocations getSearchLocations() {
        return _searchLocations;
    }

    public int count() {
        return _count;
    }


    public void setSearchLocations(SearchLocations searchLocations) {
        _searchLocations = searchLocations;
    }

    public abstract int countPages();

    public void setHitsPerPage(int hpp) {
        _hitsPerPage = hpp;
    }

    protected void setNbPages(int nb) {
        _nbPages = nb;
    }

    public void setAllHits() {
        setHitsPerPage(HPP_ALL_HITS);
    }

    /* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		return true;
	}

	/**Init the LinkedHashMap _xmlizable_volatile_objects with the objects in order to describ them in XML
	 * Some objects need to be refresh each time a toSAX is called*/
	protected void initVolatileObjectsToSax() {

	}

}
