/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;

import org.apache.lucene.search.Searchable;

import java.io.IOException;

public interface Index extends fr.gouv.culture.sdx.search.Index{

    String CLASS_NAME_SUFFIX = "Index";
    
    /** The name of the file that represents the last modification timestamp of the index */
    String LAST_MODIFICATION_DATE_FILENAME = "last-modification-timestamp";
    
    /** The name of the file that represents the creation timestamp of the the index */
    String CREATION_TIMESTAMP_FILENAME = "creation-timestamp";

    Searchable getSearcher() throws IOException, SDXException;

    //Readable getReader() throws IOException;

    Field getField(String name) throws IOException;

    Field getDefaultField() throws IOException;

    QueryParser getQueryParser() throws IOException, SDXException;


}
