/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
/*
 * Created by IntelliJ IDEA.
 * User: fglorieux
 * Date: 24 sept. 2002
 * Time: 21:25:14
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.sitemap;

import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ConfigurableServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

import java.util.HashMap;
import java.util.Map;


public class SuperuserAction extends ConfigurableServiceableAction
        implements ThreadSafe {
    fr.gouv.culture.sdx.framework.FrameworkImpl sdx_frame;

    public Map act(Redirector redirector,
                   SourceResolver resolver,
                   Map objectModel,
                   String source,
                   Parameters params) throws ServiceException {
    	
        Map sitemapParams = new HashMap();
        sitemapParams.put("superuser", "true");

        try {
            ConfigurationUtils.checkServiceManager(this.manager);
            Object sdx_temp = this.manager.lookup(fr.gouv.culture.sdx.framework.Framework.ROLE);
            sdx_frame = (fr.gouv.culture.sdx.framework.FrameworkImpl) sdx_temp;
            if (sdx_frame == null || !sdx_frame.isSuperUserSet()) return null;
            return sitemapParams;
        } finally {
            if (sdx_frame != null) manager.release(sdx_frame);
        }
    }
}

