/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.logger.LogEnabled;

/**
 * An abstract and simple implementation of an identity using an XML document.
 *
 * <p>
 * This abstract class takes care of the name and type methods. By extending XMLdocument,
 * it also takes care of most of the indexing process.
 */
public abstract class AbstractIdentity extends XMLDocument implements Identity, LogEnabled {

    /** The type of identity. */
    private int type;

    /** Creates an empty identity.
     * @throws SDXException if identity can not be built
     */
    public AbstractIdentity() throws SDXException {
        super();
    }

    /** Creates an identity with a given id.
     * @param id An id for the identity.
     * @throws SDXException if identity can not be built
     */
    public AbstractIdentity(String id) throws SDXException {
        super(id);
    }

    /** Returns the type of identity.
     * @deprecated Use {@link fr.gouv.culture.sdx.document.Document#getDoctype getDoctype()}
     * @return The type.
     */
    public int getType() {
        return this.type;
    }

    /**
     * Sets the type of this identity (@see ???).
     *
     * @param   type    The identity type.
     */
    public void setType(int type) {
        this.type = type;
    }


}
