/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.TermHighlighter;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.XMLFieldFilter;
import fr.gouv.culture.sdx.search.lucene.query.AbstractResponse;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.ResultDocument;
import fr.gouv.culture.sdx.search.lucene.query.ResultDocuments;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.SortSpecification;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Hits;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Results
extends AbstractResponse
implements fr.gouv.culture.sdx.search.Results {
    private Query query;
    private SortSpecification sorts;
    private ResultDocuments sortedResults;
    private float topScore = 1.0f;
    private TermHighlighter highlighter = null;
    private Hits hits = null;

    public Results() {
    }

    public Results(Results results) throws SDXException, IOException {
        this.setUp(results.getSearchLocations(), results.getHits(), null, results.getQuery());
    }

    public void setUp(SearchLocations sLocs, Hits searchHits, SortSpecification sorts, Query query) throws SDXException, IOException {
        if (sLocs == null) {
            throw new SDXException(null, 4000, null, null);
        }
        if (searchHits == null) {
            throw new SDXException(super.getLog(), 4003, null, null);
        }
        this.hits = searchHits;
        this.query = query;
        this.sorts = sorts;
        this._searchLocations = sLocs;
        if (this.sorts == null) {
            this.sorts = new SortSpecification();
        }
        this.sorts.enableLogging(super.getLog());
        try {
            if (searchHits.length() > 0) {
                this.topScore = searchHits.score(0);
            }
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4400, args, e);
        }
        this.sortedResults = this.sorts.sortResults(searchHits);
        super.setNbPages(this.countPages());
    }

    public void setUp(SearchLocations sLocs, Hits searchHits, Query query) throws SDXException {
        if (searchHits == null) {
            throw new SDXException(super.getLog(), 4003, null, null);
        }
        this.query = query;
        this._searchLocations = sLocs;
        this.sorts = new SortSpecification();
        this.sorts.enableLogging(super.getLog());
        try {
            if (searchHits.length() > 0) {
                this.topScore = searchHits.score(0);
            }
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(super.getLog(), 4400, args, e);
        }
        this.sortedResults = this.sorts.sortResults(searchHits);
        super.setNbPages(this.countPages());
    }

    public Hits getHits() {
        return this.hits;
    }

    public void toSAX(ContentHandler hdl) throws SAXException {
        try {
            this.toSAX(hdl, 1, false);
        }
        catch (SDXException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public void toSAX(ContentHandler hdl, boolean getDocuments) throws SDXException, Exception {
        this.toSAX(hdl, 1, getDocuments);
    }

    public void toSAX(ContentHandler hdl, int pageNo) throws SDXException, Exception {
        this.toSAX(hdl, pageNo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toSAX(ContentHandler hdl, int pageNo, boolean getDocuments) throws SDXException, SAXException {
        int eIdx;
        int sIdx;
        int nbHits = this.sortedResults.getLength();
        if (nbHits > 0) {
            if (pageNo < 1) {
                pageNo = 1;
            }
            if (pageNo > super.getNbPages()) {
                pageNo = super.getNbPages();
            }
            sIdx = (pageNo - 1) * this.getHitsPerPage() + 1;
            eIdx = pageNo * this.getHitsPerPage();
            if (sIdx < 1) {
                sIdx = 1;
            }
            if (eIdx > nbHits) {
                eIdx = nbHits;
            }
        } else {
            pageNo = 0;
            sIdx = 0;
            eIdx = 0;
        }
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "results";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "qid", "qid", "CDATA", String.valueOf(super.getId()));
        atts.addAttribute("", "page", "page", "CDATA", String.valueOf(pageNo));
        atts.addAttribute("", "hpp", "hpp", "CDATA", String.valueOf(super.getHitsPerPage()));
        atts.addAttribute("", "pages", "pages", "CDATA", String.valueOf(super.getNbPages()));
        atts.addAttribute("", "nb", "nb", "CDATA", String.valueOf(nbHits));
        atts.addAttribute("", "start", "start", "CDATA", String.valueOf(sIdx));
        atts.addAttribute("", "end", "end", "CDATA", String.valueOf(eIdx));
        atts.addAttribute("", "id", "id", "CDATA", String.valueOf(super.getId()));
        atts.addAttribute("", "currentPage", "currentPage", "CDATA", String.valueOf(pageNo));
        atts.addAttribute("", "nbPages", "nbPages", "CDATA", String.valueOf(super.getNbPages()));
        hdl.startElement(sdxNsUri, localName, qName, atts);
        if (this.query != null) {
            this.query.toSAX(hdl);
        }
        if (this.sorts != null) {
            this.sorts.toSAX(hdl);
        }
        try {
            if (nbHits > 0 && super.getNbPages() != 0) {
                Document resultDoc = null;
                Enumeration fields = null;
                String previousDocId = null;
                float maxScore = this.getMaxScore();
                for (int i = sIdx; i <= eIdx; ++i) {
                    ResultDocument currentDocument = this.sortedResults.getDocument(i - 1);
                    if (currentDocument == null) continue;
                    String childOneLocalName = "result";
                    String childOneQName = sdxNsPrefix + ":" + childOneLocalName;
                    AttributesImpl childOneAtts = new AttributesImpl();
                    childOneAtts.addAttribute("", "no", "no", "CDATA", String.valueOf(i));
                    childOneAtts.addAttribute("", "score", "score", "CDATA", String.valueOf(currentDocument.getScore()));
                    float pctScore = 100.0f * (currentDocument.getScore() / maxScore);
                    childOneAtts.addAttribute("", "pctScore", "pctScore", "CDATA", String.valueOf(Math.round(Math.floor(pctScore))));
                    hdl.startElement(sdxNsUri, childOneLocalName, childOneQName, childOneAtts);
                    resultDoc = currentDocument.getDocument();
                    if (resultDoc != null) {
                        fields = resultDoc.fields();
                    }
                    if (fields != null) {
                        while (fields.hasMoreElements()) {
                            Field field = (Field)fields.nextElement();
                            if (field == null) continue;
                            String fieldName = field.name();
                            String childTwoLocalName = "field";
                            String childTwoQName = sdxNsPrefix + ":" + childTwoLocalName;
                            AttributesImpl childTwoAtts = new AttributesImpl();
                            int fieldType = this._searchLocations.getFieldType(fieldName);
                            String value = "";
                            value = field.stringValue();
                            childTwoAtts.addAttribute("", "name", "name", "CDATA", fieldName);
                            if (fieldType != 4) {
                                if (fieldType == 2) {
                                    Date date = DateField.stringToDate(value);
                                    long milliSecs = 0L;
                                    if (date != null) {
                                        milliSecs = date.getTime();
                                    }
                                    value = fr.gouv.culture.sdx.utils.Date.formatDate(date);
                                    childTwoAtts.addAttribute("", "timeInMilliseconds", "timeInMilliseconds", "CDATA", String.valueOf(milliSecs));
                                }
                                String esc = "";
                                esc = Utilities.encodeURL(value, super.getEncoding());
                                childTwoAtts.addAttribute("", "value", "value", "CDATA", value);
                                if (esc != null) {
                                    childTwoAtts.addAttribute("", "escapedValue", "escapedValue", "CDATA", esc);
                                }
                            }
                            String fieldTypeName = "";
                            fieldTypeName = this._searchLocations.getTypeName(fieldName);
                            if (fieldTypeName != null) {
                                childTwoAtts.addAttribute("", "type", "type", "CDATA", fieldTypeName);
                            }
                            childTwoAtts.addAttribute("", "indexed", "indexed", "CDATA", String.valueOf(field.isIndexed()));
                            childTwoAtts.addAttribute("", "tokenized", "tokenized", "CDATA", String.valueOf(field.isTokenized()));
                            hdl.startElement(sdxNsUri, childTwoLocalName, childTwoQName, childTwoAtts);
                            if (fieldType == 4) {
                                XMLFieldFilter filter = new XMLFieldFilter();
                                filter.setContentHandler(hdl);
                                try {
                                    SAXParser parser = (SAXParser)this._manager.lookup(SAXParser.ROLE);
                                    parser.parse(new InputSource(new ByteArrayInputStream(value.getBytes("UTF-8"))), (ContentHandler)((Object)filter));
                                }
                                catch (ServiceException e) {
                                    throw new SDXException("Error loading the parser for xml field", e);
                                }
                                catch (IOException e) {
                                    throw new SDXException("Error parsing the xml field", e);
                                }
                            } else {
                                char[] chars = value.toCharArray();
                                hdl.characters(chars, 0, chars.length);
                            }
                            hdl.endElement(sdxNsUri, childTwoLocalName, childTwoQName);
                            if (!fieldName.equals("sdxdocid")) continue;
                            previousDocId = resultDoc.get(fieldName);
                        }
                    }
                    hdl.endElement(sdxNsUri, childOneLocalName, childOneQName);
                }
            }
            hdl.endElement(sdxNsUri, localName, qName);
            Object var33_35 = null;
        }
        catch (Throwable throwable) {
            Object var33_36 = null;
            throw throwable;
        }
    }

    public int countPages() {
        if (super.getHitsPerPage() == 0) {
            return 1;
        }
        int nbHits = this.sortedResults.getLength();
        if (nbHits == 0) {
            return 0;
        }
        float temp = (float)nbHits / (float)super.getHitsPerPage();
        if (temp != (float)Math.round(temp)) {
            return (int)Math.round(Math.floor(temp) + 1.0);
        }
        return Math.round(temp);
    }

    public void setAllHits() {
        super.setHitsPerPage(this.sortedResults.getLength());
        super.setNbPages(1);
    }

    public void setHitsPerPage(int nb) {
        if (nb < 0) {
            this.setAllHits();
        } else {
            super.setHitsPerPage(nb);
            super.setNbPages(this.countPages());
        }
    }

    public void getQueryAsSAX(ContentHandler hdl) throws SDXException, SAXException, ProcessingException {
        this.query.toSAX(hdl);
    }

    public String[] getDocIds() throws SDXException, IOException {
        int nbHits = this.sortedResults.getLength();
        String[] docIds = new String[nbHits];
        Document doc = null;
        for (int i = 0; i < nbHits; ++i) {
            doc = this.sortedResults.getDocument(i).getDocument();
            docIds[i] = doc.get("sdxdocid");
        }
        return docIds;
    }

    public Query getQuery() {
        return this.query;
    }

    public void getNavigationAsSAX(ContentHandler hdl, int docNo) throws SDXException, SAXException, ProcessingException, IOException {
        if (hdl == null) {
            throw new SDXException(super.getLog(), 215, null, null);
        }
        int nbHits = this.sortedResults.getLength();
        if (docNo <= nbHits && docNo > 0 && this.sortedResults.getDocument(docNo - 1) != null) {
            String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
            String sdxNsPrefix = "sdx";
            String localName = "navigation";
            String qName = sdxNsPrefix + ":" + localName;
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "qid", "qid", "CDATA", String.valueOf(super.getId()));
            atts.addAttribute("", "page", "page", "CDATA", "" + this.getPage(docNo));
            atts.addAttribute("", "no", "no", "CDATA", "" + docNo);
            atts.addAttribute("", "queryId", "queryId", "CDATA", String.valueOf(super.getId()));
            atts.addAttribute("", "docNo", "docNo", "CDATA", "" + docNo);
            hdl.startElement(sdxNsUri, localName, qName, atts);
            if (this.query != null) {
                this.query.toSAX(hdl);
            }
            if (docNo > 1 && this.sortedResults.getDocument(docNo - 2) != null) {
                String childOneLocalName = "previous";
                String childOneQName = sdxNsPrefix + ":" + childOneLocalName;
                AttributesImpl childOneAtts = new AttributesImpl();
                childOneAtts.addAttribute("", "id", "id", "CDATA", this.sortedResults.getDocument(docNo - 2).getFieldValue("sdxdocid"));
                childOneAtts.addAttribute("", "base", "base", "CDATA", this.sortedResults.getDocument(docNo - 2).getFieldValue("sdxdbid"));
                childOneAtts.addAttribute("", "app", "app", "CDATA", this.sortedResults.getDocument(docNo - 2).getFieldValue("sdxappid"));
                childOneAtts.addAttribute("", "no", "no", "CDATA", "" + String.valueOf(docNo - 1));
                childOneAtts.addAttribute("", "page", "page", "CDATA", "" + this.getPage(docNo - 1));
                childOneAtts.addAttribute("", "docId", "docId", "CDATA", this.sortedResults.getDocument(docNo - 2).getFieldValue("sdxdocid"));
                hdl.startElement(sdxNsUri, childOneLocalName, childOneQName, childOneAtts);
                hdl.endElement(sdxNsUri, childOneLocalName, childOneQName);
            }
            if (docNo < nbHits && this.sortedResults.getDocument(docNo) != null) {
                String childTwoLocalName = "next";
                String childTwoQName = sdxNsPrefix + ":" + childTwoLocalName;
                AttributesImpl childTwoAtts = new AttributesImpl();
                childTwoAtts.addAttribute("", "id", "id", "CDATA", this.sortedResults.getDocument(docNo).getFieldValue("sdxdocid"));
                childTwoAtts.addAttribute("", "base", "base", "CDATA", this.sortedResults.getDocument(docNo).getFieldValue("sdxdbid"));
                childTwoAtts.addAttribute("", "app", "app", "CDATA", this.sortedResults.getDocument(docNo).getFieldValue("sdxappid"));
                childTwoAtts.addAttribute("", "no", "no", "CDATA", "" + String.valueOf(docNo + 1));
                childTwoAtts.addAttribute("", "page", "page", "CDATA", "" + this.getPage(docNo + 1));
                childTwoAtts.addAttribute("", "docId", "docId", "CDATA", this.sortedResults.getDocument(docNo).getFieldValue("sdxdocid"));
                hdl.startElement(sdxNsUri, childTwoLocalName, childTwoQName, childTwoAtts);
                hdl.endElement(sdxNsUri, childTwoLocalName, childTwoQName);
            }
            hdl.endElement(sdxNsUri, localName, qName);
        } else if (docNo > -1) {
            // empty if block
        }
    }

    public void getNavigationAsSAX(ContentHandler hdl, String id) throws SDXException, SAXException, ProcessingException, IOException {
        String[] docIds = this.getDocIds();
        for (int i = 0; i < docIds.length; ++i) {
            if (!id.equals(docIds[i])) continue;
            this.getNavigationAsSAX(hdl, i + 1);
            return;
        }
    }

    private int getPage(int docNo) {
        float temp;
        if (docNo < 1) {
            docNo = 1;
        }
        if ((temp = (float)docNo / (float)super.getHitsPerPage()) != (float)Math.round(temp)) {
            return (int)Math.round(Math.floor(temp) + 1.0);
        }
        return Math.round(temp);
    }

    public void reSort(SortSpecification sorts) throws IOException, SDXException {
        this.sorts = sorts;
        if (this.sorts == null) {
            this.sorts = new SortSpecification();
        }
        this.sorts.enableLogging(super.getLog());
        this.sortedResults = this.sorts.sortResults(this.sortedResults);
    }

    public int count() {
        if (this.sortedResults == null) {
            return 0;
        }
        return this.sortedResults.getLength();
    }

    public float getMaxScore() {
        return this.topScore;
    }

    public TermHighlighter getHighliter() {
        return this.highlighter;
    }

    public void setHighliter(TermHighlighter hliter) {
        this.highlighter = hliter;
    }

    protected String getClassNameSuffix() {
        return "Results";
    }
}

