/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.elementprocessor.CannotCreateElementProcessorException;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.ElementProcessorFactory;
import org.apache.cocoon.components.elementprocessor.types.Attribute;
import org.apache.cocoon.serialization.Serializer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class ElementProcessorSerializer
extends AbstractLogEnabled
implements Serializer,
Serviceable {
    private static final boolean _should_set_content_length = false;
    private OutputStream _output_stream = null;
    private Stack _open_elements = new Stack();
    private Locator _locator = null;
    protected ServiceManager manager = null;

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    protected abstract ElementProcessorFactory getElementProcessorFactory();

    protected abstract void doPreInitialization(ElementProcessor var1) throws SAXException;

    protected OutputStream getOutputStream() {
        return this._output_stream;
    }

    protected SAXException SAXExceptionFactory(String message, Exception e) {
        StringBuffer message_buffer = new StringBuffer();
        message_buffer.append(message == null ? "" : message);
        if (this._locator != null) {
            message_buffer.append("; System id: \"");
            message_buffer.append(this._locator.getSystemId());
            message_buffer.append("\"; public id: \"");
            message_buffer.append(this._locator.getPublicId());
            message_buffer.append("\"; line number: ");
            message_buffer.append(this._locator.getLineNumber());
            message_buffer.append("; column number: ");
            message_buffer.append(this._locator.getColumnNumber());
        }
        SAXException rval = null;
        rval = e != null ? new SAXException(message_buffer.toString(), e) : new SAXException(message_buffer.toString());
        return rval;
    }

    protected SAXException SAXExceptionFactory(String message) {
        return this.SAXExceptionFactory(message, null);
    }

    private ElementProcessor getCurrentElementProcessor() {
        return this._open_elements.empty() ? null : (ElementProcessor)this._open_elements.peek();
    }

    private char[] cleanupArray(char[] array, int start, int length) {
        char[] output = new char[length];
        System.arraycopy(array, start, output, 0, length);
        return output;
    }

    public void setOutputStream(OutputStream out) {
        this._output_stream = out;
    }

    public boolean shouldSetContentLength() {
        return false;
    }

    public void comment(char[] ignored_ch, int ignored_start, int ignored_length) {
    }

    public void endCDATA() {
    }

    public void endDTD() {
    }

    public void endEntity(String ignored_name) {
    }

    public void startCDATA() {
    }

    public void startDTD(String ignored_name, String ignored_publicId, String ignored_systemId) {
    }

    public void startEntity(String ignored_name) {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.getCurrentElementProcessor().acceptCharacters(this.cleanupArray(ch, start, length));
        }
        catch (Exception e) {
            throw this.SAXExceptionFactory("could not process characters event", e);
        }
    }

    public void endElement(String ignored_namespaceURI, String ignored_localName, String ignored_qName) throws SAXException {
        try {
            this.getCurrentElementProcessor().endProcessing();
            this._open_elements.pop();
        }
        catch (Exception e) {
            throw this.SAXExceptionFactory("could not process endElement event", e);
        }
    }

    public void endPrefixMapping(String ignored_prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.getCurrentElementProcessor().acceptWhitespaceCharacters(this.cleanupArray(ch, start, length));
        }
        catch (Exception e) {
            throw this.SAXExceptionFactory("could not process ignorableWhitespace event", e);
        }
    }

    public void processingInstruction(String ignored_target, String ignored_data) {
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void skippedEntity(String ignored_name) {
    }

    public void startDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        ElementProcessor processor;
        String name = "";
        if (localName != null && localName.length() != 0) {
            name = localName;
        } else if (qName != null && qName.length() != 0) {
            name = qName;
        }
        try {
            processor = this.getElementProcessorFactory().createElementProcessor(name);
        }
        catch (CannotCreateElementProcessorException e) {
            throw this.SAXExceptionFactory("could not process startElement event", e);
        }
        this.doPreInitialization(processor);
        Attribute[] attributes = atts == null ? new Attribute[]{} : new Attribute[atts.getLength()];
        int j = 0;
        while (j < attributes.length) {
            attributes[j] = new Attribute(atts.getQName(j), atts.getValue(j));
            ++j;
        }
        try {
            processor.initialize(attributes, this.getCurrentElementProcessor());
        }
        catch (IOException e) {
            throw this.SAXExceptionFactory("Exception processing startElement", e);
        }
        this._open_elements.push(processor);
    }

    public void startPrefixMapping(String ignored_prefix, String ignored_uri) {
    }
}

