/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.impl.AbstractSource;

public class CommonsVFSSource
extends AbstractSource
implements LogEnabled,
ModifiableSource {
    private final String m_location;
    private final FileSystemManager m_manager;
    private final FileObject m_fileObject;
    private final FileContent m_fileContent;
    private Logger m_logger;

    public CommonsVFSSource(String location, Map parameters) throws FileSystemException {
        this.m_location = location;
        this.m_manager = VFS.getManager();
        this.m_fileObject = this.m_manager.resolveFile(location);
        this.m_fileContent = this.m_fileObject.getContent();
    }

    protected void getInfos() {
        try {
            this.setContentLength(this.m_fileContent.getSize());
        }
        catch (FileSystemException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unable to determine content length for " + this.m_location, (Throwable)e);
            }
            this.setContentLength(-1L);
        }
        try {
            this.setLastModified(this.m_fileContent.getLastModifiedTime());
        }
        catch (FileSystemException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unable to determine last modified date for " + this.m_location, (Throwable)e);
            }
            this.setLastModified(0L);
        }
        this.setSystemId(this.m_location);
        this.setScheme(SourceUtil.getScheme(this.m_location));
    }

    public InputStream getInputStream() throws IOException, SourceException {
        return this.m_fileContent.getInputStream();
    }

    public boolean exists() {
        try {
            return this.m_fileObject.exists();
        }
        catch (FileSystemException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unable to determine existence for " + this.m_location, (Throwable)e);
            }
            return false;
        }
    }

    public boolean canCancel(OutputStream stream) {
        return false;
    }

    public void cancel(OutputStream stream) throws IOException {
        throw new IOException("Cancel() not implemented");
    }

    public void delete() throws SourceException {
        try {
            this.m_fileObject.delete();
        }
        catch (FileSystemException e) {
            throw new SourceException("Unable to delete resource: " + this.m_location, e);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.m_fileContent.getOutputStream();
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

