/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail.datasource;

import java.io.IOException;
import java.io.InputStream;
import org.apache.cocoon.mail.datasource.AbstractDataSource;
import org.apache.excalibur.source.Source;

public class SourceDataSource
extends AbstractDataSource {
    private Source src;

    public SourceDataSource(Source src) {
        this(src, null, null);
    }

    public SourceDataSource(Source src, String type, String name) {
        super(SourceDataSource.getName(name, src), SourceDataSource.getType(type, src));
        this.src = src;
    }

    private static String getName(String name, Source src) {
        if (SourceDataSource.isNullOrEmpty(name)) {
            name = src.getURI();
            int idx = (name = name.substring(name.lastIndexOf(47) + 1)).indexOf(63);
            if (idx > -1) {
                name = name.substring(0, idx);
            }
            if (SourceDataSource.isNullOrEmpty(name)) {
                name = "attachment";
            }
        }
        return name;
    }

    private static String getType(String type, Source src) {
        if (SourceDataSource.isNullOrEmpty(type) && SourceDataSource.isNullOrEmpty(type = src.getMimeType())) {
            type = "application/octet-stream";
        }
        return type;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.src.getInputStream();
        }
        catch (IOException e) {
            if (this.getLogger() != null) {
                this.getLogger().warn("Unable to obtain input stream for '" + this.src.getURI() + "'", (Throwable)e);
            }
            throw e;
        }
    }
}

