/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.aspect.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.portal.aspect.AspectDataHandler;
import org.apache.cocoon.portal.aspect.AspectDataStore;
import org.apache.cocoon.portal.aspect.AspectDescription;
import org.apache.cocoon.portal.aspect.Aspectalizable;
import org.apache.cocoon.portal.aspect.AspectalizableDescription;
import org.apache.cocoon.portal.aspect.impl.AspectDatasHashMap;
import org.apache.cocoon.portal.aspect.impl.AspectUtil;

public class DefaultAspectDataHandler
implements AspectDataHandler {
    protected AspectalizableDescription description;
    protected ServiceSelector storeSelector;

    public DefaultAspectDataHandler(AspectalizableDescription desc, ServiceSelector storeSelector) {
        this.description = desc;
        this.storeSelector = storeSelector;
    }

    public Object getAspectData(Aspectalizable owner, String aspectName) {
        AspectDescription aspectDesc = this.description.getAspectDescription(aspectName);
        if (aspectDesc == null) {
            return null;
        }
        AspectDataStore store = null;
        Object data = null;
        try {
            block5: {
                try {
                    store = (AspectDataStore)this.storeSelector.select((Object)aspectDesc.getStoreName());
                    data = store.getAspectData(owner, aspectName);
                    if (data != null || !aspectDesc.isAutoCreate()) break block5;
                    data = AspectUtil.createNewInstance(aspectDesc);
                    store.setAspectData(owner, aspectName, data);
                }
                catch (ServiceException ce) {
                    throw new CascadingRuntimeException("Unable to lookup aspect data store " + aspectDesc.getStoreName(), (Throwable)ce);
                }
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.storeSelector.release((Object)store);
            throw throwable;
        }
        this.storeSelector.release((Object)store);
        return data;
    }

    public Map getAspectDatas(Aspectalizable owner) {
        AspectDatasHashMap datas = new AspectDatasHashMap(owner, this);
        Iterator iter = this.description.getAspectDescriptions().iterator();
        while (iter.hasNext()) {
            AspectDescription current = (AspectDescription)iter.next();
            Object data = this.getAspectData(owner, current.getName());
            if (data == null) continue;
            datas.put(current.getName(), data);
        }
        datas.initialize();
        return datas;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map getPersistentAspectDatas(Aspectalizable owner) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        Iterator iter = this.description.getAspectDescriptions().iterator();
        while (iter.hasNext()) {
            Object var9_7;
            AspectDescription current = (AspectDescription)iter.next();
            AspectDataStore store = null;
            Object data = null;
            try {
                block8: {
                    try {
                        store = (AspectDataStore)this.storeSelector.select((Object)current.getStoreName());
                        if (!store.isPersistent()) break block8;
                        data = store.getAspectData(owner, current.getName());
                        if (data == null && current.isAutoCreate()) {
                            data = AspectUtil.createNewInstance(current);
                            store.setAspectData(owner, current.getName(), data);
                        }
                        if (data != null) {
                            datas.put(current.getName(), data);
                        }
                    }
                    catch (ServiceException ce) {
                        throw new CascadingRuntimeException("Unable to lookup aspect data store " + current.getStoreName(), (Throwable)ce);
                    }
                }
                var9_7 = null;
            }
            catch (Throwable throwable) {
                var9_7 = null;
                this.storeSelector.release((Object)store);
                throw throwable;
            }
            this.storeSelector.release((Object)store);
        }
        return datas;
    }

    public void setAspectData(Aspectalizable owner, String aspectName, Object data) {
        AspectDescription aspectDesc = this.description.getAspectDescription(aspectName);
        if (aspectDesc == null) {
            return;
        }
        AspectDataStore store = null;
        try {
            try {
                store = (AspectDataStore)this.storeSelector.select((Object)aspectDesc.getStoreName());
                store.setAspectData(owner, aspectName, AspectUtil.convert(aspectDesc, data));
            }
            catch (ServiceException ce) {
                throw new CascadingRuntimeException("Unable to lookup aspect data store " + aspectDesc.getStoreName(), (Throwable)ce);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.storeSelector.release((Object)store);
            throw throwable;
        }
        this.storeSelector.release((Object)store);
    }

    public boolean isAspectSupported(String aspectName) {
        return this.description.getAspectDescription(aspectName) != null;
    }
}

