/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.portal.PortalComponentManager;

public class PortalServiceInfo {
    private Map portalComponentManagers;
    private Map objectModel;
    protected Map temporaryAttributes = new HashMap();
    protected String portalName;
    protected String attributePrefix;
    protected PortalComponentManager portalComponentManager;

    public void setup(Map objectModel, Map managers) {
        String portalName;
        this.objectModel = objectModel;
        this.portalComponentManagers = managers;
        Map context = (Map)objectModel.get("parent-context");
        if (context != null && (portalName = (String)context.get("cocoon-portal-portalName")) != null) {
            this.setPortalName(portalName);
        }
    }

    public String getPortalName() {
        return this.portalName;
    }

    public void setPortalName(String value) {
        this.portalName = value;
        this.attributePrefix = this.getClass().getName() + '/' + this.portalName + '/';
        this.portalComponentManager = (PortalComponentManager)this.portalComponentManagers.get(this.portalName);
        if (this.portalComponentManager == null) {
            throw new RuntimeException("Portal '" + this.portalName + "' is not configured.");
        }
    }

    public Object getAttribute(String key) {
        Session session = ObjectModelHelper.getRequest((Map)this.objectModel).getSession(false);
        if (session == null) {
            return null;
        }
        return session.getAttribute(this.attributePrefix + key);
    }

    public void setAttribute(String key, Object value) {
        Session session = ObjectModelHelper.getRequest((Map)this.objectModel).getSession();
        session.setAttribute(this.attributePrefix + key, value);
    }

    public void removeAttribute(String key) {
        Session session = ObjectModelHelper.getRequest((Map)this.objectModel).getSession(false);
        if (session != null) {
            session.removeAttribute(this.attributePrefix + key);
        }
    }

    public Iterator getAttributeNames() {
        Session session = ObjectModelHelper.getRequest((Map)this.objectModel).getSession(false);
        if (session != null) {
            ArrayList<String> names = new ArrayList<String>();
            Enumeration e = session.getAttributeNames();
            int pos = this.attributePrefix.length() + 1;
            if (e != null) {
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (!name.startsWith(this.attributePrefix)) continue;
                    names.add(name.substring(pos));
                }
            }
            return names.iterator();
        }
        return Collections.EMPTY_MAP.keySet().iterator();
    }

    public Object getTemporaryAttribute(String key) {
        return this.temporaryAttributes.get(key);
    }

    public void setTemporaryAttribute(String key, Object value) {
        this.temporaryAttributes.put(key, value);
    }

    public void removeTemporaryAttribute(String key) {
        this.temporaryAttributes.remove(key);
    }

    public Iterator getTemporaryAttributeNames() {
        return this.temporaryAttributes.keySet().iterator();
    }

    public PortalComponentManager getComponentManager() {
        return this.portalComponentManager;
    }
}

