/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Revert
extends SvnCommand {
    private File file = null;
    private File dir = null;
    private boolean recurse = false;
    private Vector filesets = new Vector();

    public void execute() throws SvnAntException {
        if (this.file != null) {
            this.revertFile(this.file, false);
        }
        if (this.dir != null) {
            this.revertFile(this.dir, this.recurse);
        }
        if (this.filesets.size() > 0) {
            for (int i = 0; i < this.filesets.size(); ++i) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(i);
                this.revertFileSet(fileSet);
            }
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.file != null) {
            if (this.dir != null) {
                throw new SvnAntValidationException("Don't use both file and dir attribute");
            }
            if (this.filesets.size() > 0) {
                throw new SvnAntValidationException("Don't use both file attribute and filesets");
            }
        } else if (this.dir != null && this.filesets.size() > 0) {
            throw new SvnAntValidationException("Don't use both file attribute and filesets");
        }
    }

    private void revertFile(File file, boolean bl) throws SvnAntException {
        try {
            this.svnClient.revert(file, bl);
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Cannot revert file or directory " + file.getAbsolutePath(), sVNClientException);
        }
    }

    private void revertFileSet(FileSet fileSet) throws SvnAntException {
        int n;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        File[] fileArray = new File[stringArray.length + stringArray2.length];
        int n2 = 0;
        for (n = 0; n < stringArray2.length; ++n) {
            fileArray[n2] = new File(file, stringArray2[n]);
            ++n2;
        }
        for (n = 0; n < stringArray.length; ++n) {
            fileArray[n2] = new File(file, stringArray[n]);
            ++n2;
        }
        try {
            for (n = 0; n < fileArray.length; ++n) {
                this.svnClient.revert(fileArray[n], false);
            }
        }
        catch (SVNClientException sVNClientException) {
            this.logError("Cannot revert file " + this.file.getAbsolutePath());
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void add(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }
}

