/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.SvnTask;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.utils.StringUtils;

public abstract class SvnCommand
extends ProjectComponent {
    protected SvnTask task;
    protected ISVNClientAdapter svnClient;

    protected abstract void validateAttributes() throws SvnAntValidationException;

    public abstract void execute() throws SvnAntException;

    public final void executeCommand(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        String[] stringArray = StringUtils.split((String)((Object)((Object)this)).getClass().getName(), (String)".");
        String string = "<" + stringArray[stringArray.length - 1] + ">";
        this.logInfo(string + " started ...");
        try {
            this.validateAttributes();
            this.execute();
        }
        catch (SvnAntException svnAntException) {
            if (this.task.isFailonerror()) {
                this.logInfo(string + " failed !");
                throw new BuildException(svnAntException.getMessage(), svnAntException.getCause());
            }
            this.logError(string + " failed :" + svnAntException.getLocalizedMessage());
        }
        catch (SvnAntValidationException svnAntValidationException) {
            if (this.task.isFailonerror()) {
                this.logInfo(string + " failed !");
                throw new BuildException(svnAntValidationException.getMessage());
            }
            this.logError(string + " failed :" + svnAntValidationException.getLocalizedMessage());
        }
        this.logInfo(string + " finished.");
    }

    public SvnTask getTask() {
        return this.task;
    }

    public void setTask(SvnTask svnTask) {
        this.task = svnTask;
    }

    public SVNRevision getRevisionFrom(String string) {
        try {
            return SVNRevision.getRevision((String)string, (SimpleDateFormat)this.getDateFormatter());
        }
        catch (ParseException parseException) {
            this.logWarning("Unable to parse revision string");
            return null;
        }
    }

    public String getDateStringFor(Date date) {
        return this.getDateFormatter().format(date);
    }

    private SimpleDateFormat getDateFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.task.getDateFormatter());
        TimeZone timeZone = this.task.getDateTimeZone();
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat;
    }

    public void logVerbose(String string) {
        this.getProject().log((Task)this.task, string, 3);
    }

    public void logWarning(String string) {
        this.getProject().log((Task)this.task, string, 1);
    }

    public void logError(String string) {
        this.getProject().log((Task)this.task, string, 0);
    }

    public void logInfo(String string) {
        this.getProject().log((Task)this.task, string, 2);
    }

    public void log(String string) {
        this.getProject().log((Task)this.task, string, 2);
    }

    public void log(String string, int n) {
        this.getProject().log((Task)this.task, string, n);
    }
}

