/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Switch
extends SvnCommand {
    private File path = null;
    private SVNUrl url;
    private SVNRevision revision = SVNRevision.HEAD;
    private boolean recurse = true;

    public void execute() throws SvnAntException {
        try {
            this.svnClient.switchToUrl(this.path, this.url, this.revision, this.recurse);
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Cannot switch to url : " + this.url.toString(), sVNClientException);
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.path == null || this.url == null) {
            throw new SvnAntValidationException("path and url must be set");
        }
        if (this.revision == null) {
            throw SvnAntValidationException.createInvalidRevisionException();
        }
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }
}

