/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.pipeline.OutputComponentSelector;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.reading.Reader;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.sitemap.SitemapErrorHandler;
import org.apache.cocoon.sitemap.SitemapModelComponent;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.util.location.Locatable;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractProcessingPipeline
extends AbstractLogEnabled
implements ProcessingPipeline,
Parameterizable,
Recyclable {
    protected Generator generator;
    protected Parameters generatorParam;
    protected String generatorSource;
    protected ComponentSelector generatorSelector;
    protected ArrayList transformers = new ArrayList();
    protected ArrayList transformerParams = new ArrayList();
    protected ArrayList transformerSources = new ArrayList();
    protected ArrayList transformerSelectors = new ArrayList();
    protected Serializer serializer;
    protected Parameters serializerParam;
    protected String serializerSource;
    protected String serializerMimeType;
    protected String sitemapSerializerMimeType;
    protected OutputComponentSelector serializerSelector;
    protected Reader reader;
    protected Parameters readerParam;
    protected String readerSource;
    protected String readerMimeType;
    protected String sitemapReaderMimeType;
    protected OutputComponentSelector readerSelector;
    private SitemapErrorHandler errorHandler;
    private ProcessingPipeline errorPipeline;
    private boolean prepared;
    protected XMLConsumer lastConsumer;
    protected ComponentManager manager;
    protected ComponentManager newManager;
    protected Parameters configuration;
    protected long configuredExpires;
    protected int configuredOutputBufferSize;
    protected Parameters parameters;
    protected long expires;
    protected int outputBufferSize;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.newManager = manager;
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.newManager = manager;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.configuration = params;
        String expiresValue = params.getParameter("expires", null);
        if (expiresValue != null) {
            this.configuredExpires = this.parseExpires(expiresValue);
        }
        this.configuredOutputBufferSize = params.getParameterAsInteger("outputBufferSize", -1);
    }

    public void setup(Parameters params) {
        this.parameters = params;
        String expiresValue = params.getParameter("expires", null);
        this.expires = expiresValue != null ? this.parseExpires(expiresValue) : this.configuredExpires;
        this.outputBufferSize = params.getParameterAsInteger("outputBufferSize", this.configuredOutputBufferSize);
    }

    public void release() {
        try {
            CocoonComponentManager.removeFromAutomaticRelease(this);
        }
        catch (ProcessingException e) {
            this.getLogger().error("Unable to release self from automatic release.", (Throwable)((Object)e));
        }
    }

    public void informBranchPoint() {
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. Cannot set generator '" + role + "'", this.getLocation(param));
        }
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot set generator '" + role + "'", this.getLocation(param));
        }
        try {
            this.generatorSelector = (ComponentSelector)this.newManager.lookup(Generator.ROLE + "Selector");
        }
        catch (ComponentException ce) {
            throw ProcessingException.throwLocated("Lookup of generator selector failed", (Throwable)ce, this.getLocation(param));
        }
        try {
            this.generator = (Generator)this.generatorSelector.select((Object)role);
        }
        catch (ComponentException ce) {
            throw ProcessingException.throwLocated("Lookup of generator '" + role + "' failed", (Throwable)ce, this.getLocation(param));
        }
        this.generatorSource = source;
        this.generatorParam = param;
    }

    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot add transformer '" + role + "'", this.getLocation(param));
        }
        if (this.generator == null) {
            throw new ProcessingException("Must set a generator before adding transformer '" + role + "'", this.getLocation(param));
        }
        ComponentSelector selector = null;
        try {
            selector = (ComponentSelector)this.newManager.lookup(Transformer.ROLE + "Selector");
        }
        catch (ComponentException ce) {
            throw ProcessingException.throwLocated("Lookup of transformer selector failed", (Throwable)ce, this.getLocation(param));
        }
        try {
            this.transformers.add(selector.select((Object)role));
            this.transformerSelectors.add(selector);
        }
        catch (ComponentException ce) {
            throw ProcessingException.throwLocated("Lookup of transformer '" + role + "' failed", (Throwable)ce, this.getLocation(param));
        }
        this.transformerSources.add(source);
        this.transformerParams.add(param);
    }

    public void setSerializer(String role, String source, Parameters param, Parameters hintParam, String mimeType) throws ProcessingException {
        if (this.serializer != null) {
            throw new ProcessingException("Serializer already set. Cannot set serializer '" + role + "'", this.getLocation(param));
        }
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot set serializer '" + role + "'", this.getLocation(param));
        }
        if (this.generator == null) {
            throw new ProcessingException("Must set a generator before setting serializer '" + role + "'", this.getLocation(param));
        }
        try {
            this.serializerSelector = (OutputComponentSelector)this.newManager.lookup(Serializer.ROLE + "Selector");
        }
        catch (ComponentException ce) {
            throw ProcessingException.throwLocated("Lookup of serializer selector failed", (Throwable)ce, this.getLocation(param));
        }
        try {
            this.serializer = (Serializer)this.serializerSelector.select(role);
        }
        catch (ComponentException ce) {
            throw ProcessingException.throwLocated("Lookup of serializer '" + role + "' failed", (Throwable)ce, this.getLocation(param));
        }
        this.serializerSource = source;
        this.serializerParam = param;
        this.serializerMimeType = mimeType;
        this.sitemapSerializerMimeType = this.serializerSelector.getMimeTypeForHint(role);
        this.lastConsumer = this.serializer;
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws ProcessingException {
        if (this.reader != null) {
            throw new ProcessingException("Reader already set. Cannot set reader '" + role + "'", this.getLocation(param));
        }
        if (this.generator != null) {
            throw new ProcessingException("Generator already set. Cannot use reader '" + role + "'", this.getLocation(param));
        }
        try {
            this.readerSelector = (OutputComponentSelector)this.newManager.lookup(Reader.ROLE + "Selector");
        }
        catch (ComponentException ce) {
            throw ProcessingException.throwLocated("Lookup of reader selector failed", (Throwable)ce, this.getLocation(param));
        }
        try {
            this.reader = (Reader)this.readerSelector.select(role);
        }
        catch (ComponentException ce) {
            throw ProcessingException.throwLocated("Lookup of reader '" + role + "' failed", (Throwable)ce, this.getLocation(param));
        }
        this.readerSource = source;
        this.readerParam = param;
        this.readerMimeType = mimeType;
        this.sitemapReaderMimeType = this.readerSelector.getMimeTypeForHint(role);
    }

    public void setErrorHandler(SitemapErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected boolean checkPipeline() {
        if (this.generator == null && this.reader == null) {
            return false;
        }
        return this.generator == null || this.serializer != null;
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        try {
            this.generator.setup(environment, environment.getObjectModel(), this.generatorSource, this.generatorParam);
            Iterator transformerItt = this.transformers.iterator();
            Iterator transformerSourceItt = this.transformerSources.iterator();
            Iterator transformerParamItt = this.transformerParams.iterator();
            while (transformerItt.hasNext()) {
                Transformer trans = (Transformer)transformerItt.next();
                trans.setup(environment, environment.getObjectModel(), (String)transformerSourceItt.next(), (Parameters)transformerParamItt.next());
            }
            if (this.serializer instanceof SitemapModelComponent) {
                ((SitemapModelComponent)((Object)this.serializer)).setup(environment, environment.getObjectModel(), this.serializerSource, this.serializerParam);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void connect(Environment environment, XMLProducer producer, XMLConsumer consumer) throws ProcessingException {
        producer.setConsumer(consumer);
    }

    protected void connectPipeline(Environment environment) throws ProcessingException {
        XMLProducer prev = this.generator;
        Iterator itt = this.transformers.iterator();
        while (itt.hasNext()) {
            Transformer next = (Transformer)itt.next();
            this.connect(environment, prev, next);
            prev = next;
        }
        this.connect(environment, prev, this.lastConsumer);
    }

    public boolean process(Environment environment) throws ProcessingException {
        if (!this.prepared) {
            this.preparePipeline(environment);
        }
        if (this.expires != 0L) {
            Response res = ObjectModelHelper.getResponse(environment.getObjectModel());
            res.setDateHeader("Expires", System.currentTimeMillis() + this.expires);
            res.setHeader("Cache-Control", "max-age=" + this.expires / 1000L + ", public");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Setting a new Expires object for this resource");
            }
            environment.getObjectModel().put("expires", new Long(this.expires + System.currentTimeMillis()));
        }
        if (this.reader != null) {
            if (this.checkIfModified(environment, this.reader.getLastModified())) {
                return true;
            }
            return this.processReader(environment);
        }
        if (this.lastConsumer == null) {
            this.lastConsumer = this.serializer;
        }
        this.connectPipeline(environment);
        return this.processXMLPipeline(environment);
    }

    protected void preparePipeline(Environment environment) throws ProcessingException {
        if (!this.checkPipeline()) {
            throw new ProcessingException("Attempted to process incomplete pipeline.");
        }
        if (this.prepared) {
            throw new ProcessingException("Duplicate preparePipeline call caught.");
        }
        if (this.reader != null) {
            this.setupReader(environment);
        } else {
            this.setupPipeline(environment);
        }
        this.prepared = true;
    }

    public void prepareInternal(Environment environment) throws ProcessingException {
        this.lastConsumer = null;
        try {
            this.preparePipeline(environment);
        }
        catch (ProcessingException e) {
            this.prepareInternalErrorHandler(environment, e);
        }
    }

    protected void prepareInternalErrorHandler(Environment environment, ProcessingException ex) throws ProcessingException {
        block5: {
            if (this.errorHandler != null) {
                try {
                    this.errorPipeline = this.errorHandler.prepareErrorPipeline((Exception)((Object)ex));
                    if (this.errorPipeline != null) {
                        this.errorPipeline.prepareInternal(environment);
                        return;
                    }
                    break block5;
                }
                catch (ProcessingException e) {
                    this.getLogger().error("Failed to process error handler for exception", (Throwable)((Object)ex));
                    throw e;
                }
                catch (Exception e) {
                    this.getLogger().error("Failed to process error handler for exception", (Throwable)((Object)ex));
                    throw new ProcessingException("Failed to handle exception <" + ex.getMessage() + ">", e);
                }
            }
            throw ex;
        }
    }

    protected boolean isInternalError() {
        return this.errorPipeline != null;
    }

    protected boolean processXMLPipeline(Environment environment) throws ProcessingException {
        this.setMimeTypeForSerializer(environment);
        try {
            if (this.lastConsumer == null) {
                this.generator.generate();
            } else if (this.serializer.shouldSetContentLength()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.serializer.setOutputStream(os);
                this.generator.generate();
                environment.setContentLength(os.size());
                os.writeTo(environment.getOutputStream(0));
            } else {
                this.serializer.setOutputStream(environment.getOutputStream(this.outputBufferSize));
                this.generator.generate();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return true;
    }

    protected void setupReader(Environment environment) throws ProcessingException {
        try {
            this.reader.setup(environment, environment.getObjectModel(), this.readerSource, this.readerParam);
            if (this.readerParam.isParameter("expires")) {
                this.expires = this.readerParam.getParameterAsLong("expires");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void setMimeTypeForReader(Environment environment) throws ProcessingException {
        if (this.readerMimeType != null) {
            environment.setContentType(this.readerMimeType);
        } else if (this.sitemapReaderMimeType != null) {
            environment.setContentType(this.sitemapReaderMimeType);
        } else {
            String mimeType = this.reader.getMimeType();
            if (mimeType != null) {
                environment.setContentType(mimeType);
            }
        }
    }

    protected void setMimeTypeForSerializer(Environment environment) throws ProcessingException {
        if (this.lastConsumer == null) {
            environment.setContentType("text/xml");
        } else if (this.serializerMimeType != null) {
            environment.setContentType(this.serializerMimeType);
        } else if (this.sitemapSerializerMimeType != null) {
            environment.setContentType(this.sitemapSerializerMimeType);
        } else {
            String mimeType = this.serializer.getMimeType();
            if (mimeType != null) {
                environment.setContentType(mimeType);
            } else {
                String message = "Unable to determine MIME type for " + environment.getURIPrefix() + "/" + environment.getURI();
                throw new ProcessingException(message);
            }
        }
    }

    protected boolean checkIfModified(Environment environment, long lastModified) throws ProcessingException {
        if (!environment.isResponseModified(lastModified)) {
            environment.setResponseIsNotModified();
            return true;
        }
        return false;
    }

    protected boolean processReader(Environment environment) throws ProcessingException {
        try {
            this.setMimeTypeForReader(environment);
            if (this.reader.shouldSetContentLength()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.reader.setOutputStream(os);
                this.reader.generate();
                environment.setContentLength(os.size());
                os.writeTo(environment.getOutputStream(0));
            } else {
                this.reader.setOutputStream(environment.getOutputStream(this.outputBufferSize));
                this.reader.generate();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return true;
    }

    public void recycle() {
        this.prepared = false;
        if (this.readerSelector != null) {
            this.readerSelector.release(this.reader);
            this.newManager.release((Component)this.readerSelector);
            this.readerSelector = null;
            this.reader = null;
            this.readerParam = null;
        }
        if (this.generatorSelector != null) {
            this.generatorSelector.release((Component)this.generator);
            this.newManager.release((Component)this.generatorSelector);
            this.generatorSelector = null;
            this.generator = null;
            this.generatorParam = null;
        }
        int size = this.transformerSelectors.size();
        for (int i = 0; i < size; ++i) {
            ComponentSelector selector = (ComponentSelector)this.transformerSelectors.get(i);
            selector.release((Component)this.transformers.get(i));
            this.newManager.release((Component)selector);
        }
        this.transformerSelectors.clear();
        this.transformers.clear();
        this.transformerParams.clear();
        this.transformerSources.clear();
        if (this.serializerSelector != null) {
            this.serializerSelector.release(this.serializer);
            this.newManager.release((Component)this.serializerSelector);
            this.serializerSelector = null;
            this.serializerParam = null;
        }
        this.serializer = null;
        this.parameters = null;
        this.lastConsumer = null;
        this.errorHandler = null;
        if (this.errorPipeline != null) {
            this.errorPipeline.release();
            this.errorPipeline = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(Environment environment, XMLConsumer consumer) throws ProcessingException {
        boolean bl;
        XMLConsumer xMLConsumer;
        if (this.reader != null) {
            throw new ProcessingException("Streaming of an internal pipeline is not possible with a reader.");
        }
        if (this.errorPipeline != null) {
            return this.errorPipeline.process(environment, consumer);
        }
        SaxBuffer buffer = null;
        if (this.errorHandler == null) {
            xMLConsumer = consumer;
        } else {
            buffer = new SaxBuffer();
            xMLConsumer = buffer;
        }
        this.lastConsumer = xMLConsumer;
        try {
            try {
                this.connectPipeline(environment);
                bl = this.processXMLPipeline(environment);
                Object var7_6 = null;
                if (buffer == null) return bl;
            }
            catch (ProcessingException e) {
                buffer = null;
                boolean bl2 = this.processErrorHandler(environment, e, consumer);
                Object var7_7 = null;
                if (buffer == null) return bl2;
                try {
                    buffer.toSAX((ContentHandler)((Object)consumer));
                    return bl2;
                }
                catch (SAXException e2) {
                    throw new ProcessingException("Failed to execute pipeline.", e2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (buffer == null) throw throwable;
            try {}
            catch (SAXException e2) {
                throw new ProcessingException("Failed to execute pipeline.", e2);
            }
            buffer.toSAX((ContentHandler)((Object)consumer));
            throw throwable;
        }
        try {}
        catch (SAXException e2) {
            throw new ProcessingException("Failed to execute pipeline.", e2);
        }
        buffer.toSAX((ContentHandler)((Object)consumer));
        return bl;
    }

    protected boolean processErrorHandler(Environment environment, ProcessingException e, XMLConsumer consumer) throws ProcessingException {
        if (this.errorHandler != null) {
            try {
                this.errorPipeline = this.errorHandler.prepareErrorPipeline((Exception)((Object)e));
                if (this.errorPipeline != null) {
                    this.errorPipeline.prepareInternal(environment);
                    return this.errorPipeline.process(environment, consumer);
                }
            }
            catch (Exception ignored) {
                this.getLogger().debug("Exception in error handler", (Throwable)ignored);
            }
        }
        throw e;
    }

    public SourceValidity getValidityForEventPipeline() {
        return null;
    }

    public String getKeyForEventPipeline() {
        return null;
    }

    private long parseExpires(String expire) {
        StringTokenizer tokens = new StringTokenizer(expire);
        String current = tokens.nextToken();
        if (current.equals("modification")) {
            this.getLogger().warn("the \"modification\" keyword is not yet implemented. Assuming \"now\" as the base attribute");
            current = "now";
        }
        if (!current.equals("now") && !current.equals("access")) {
            this.getLogger().error("bad <base> attribute, Expires header will not be set");
            return -1L;
        }
        long number = 0L;
        long modifier = 0L;
        long expires = 0L;
        while (tokens.hasMoreTokens()) {
            current = tokens.nextToken();
            if (current.equals("plus")) {
                current = tokens.nextToken();
            }
            try {
                number = Long.parseLong(current);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().error("state violation: a number was expected here");
                return -1L;
            }
            try {
                current = tokens.nextToken();
            }
            catch (NoSuchElementException nsee) {
                this.getLogger().error("State violation: expecting a modifier but no one found: Expires header will not be set");
            }
            if (current.equals("years")) {
                modifier = 31536000000L;
            } else if (current.equals("months")) {
                modifier = 2592000000L;
            } else if (current.equals("weeks")) {
                modifier = 604800000L;
            } else if (current.equals("days")) {
                modifier = 86400000L;
            } else if (current.equals("hours")) {
                modifier = 3600000L;
            } else if (current.equals("minutes")) {
                modifier = 60000L;
            } else if (current.equals("seconds")) {
                modifier = 1000L;
            } else {
                this.getLogger().error("Bad modifier (" + current + "): ignoring expires configuration");
                return -1L;
            }
            expires += number * modifier;
        }
        return expires;
    }

    protected Location getLocation(Parameters param) {
        Location location = null;
        if (param instanceof Locatable) {
            location = ((Locatable)param).getLocation();
        }
        if (location == null) {
            location = Location.UNKNOWN;
        }
        return location;
    }

    protected void handleException(Exception e) throws ProcessingException {
        if (e instanceof SocketException) {
            if (e.getMessage().indexOf("reset") > -1 || e.getMessage().indexOf("aborted") > -1 || e.getMessage().indexOf("Broken pipe") > -1 || e.getMessage().indexOf("connection abort") > -1) {
                throw new ConnectionResetException("Connection reset by peer", e);
            }
        } else if (e instanceof IOException) {
            if (e.getClass().getName().endsWith("ClientAbortException")) {
                throw new ConnectionResetException("Connection reset by peer", e);
            }
        } else if (e instanceof ConnectionResetException) {
            throw (ConnectionResetException)((Object)e);
        }
        if (this.reader == null) {
            ArrayList<Location> locations = new ArrayList<Location>(this.transformers.size() + 2);
            locations.add(this.getLocation(this.serializerParam));
            for (int i = this.transformerParams.size() - 1; i >= 0; --i) {
                locations.add(this.getLocation((Parameters)this.transformerParams.get(i)));
            }
            locations.add(this.getLocation(this.generatorParam));
            throw ProcessingException.throwLocated("Failed to process pipeline", (Throwable)e, locations);
        }
        throw ProcessingException.throwLocated("Failed to process reader", (Throwable)e, this.getLocation(this.readerParam));
    }
}

