/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.thread;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.thread.BoundedQueue;
import org.apache.cocoon.components.thread.ChannelWrapper;
import org.apache.cocoon.components.thread.LinkedQueue;
import org.apache.cocoon.components.thread.Queue;
import org.apache.cocoon.components.thread.SynchronousChannel;
import org.apache.cocoon.components.thread.ThreadFactory;
import org.apache.cocoon.components.thread.ThreadPool;

public class DefaultThreadPool
extends PooledExecutor
implements ThreadPool,
LogEnabled {
    public static final String POLICY_DEFAULT = "RUN";
    private ChannelWrapper m_channelWrapper;
    private Logger m_logger;
    private Queue m_queue;
    private String m_blockPolicy;
    private String m_name;
    private boolean m_shutdownGraceful;
    private int m_queueSize;
    private int m_shutdownWaitTimeMs;

    DefaultThreadPool() {
        this(new ChannelWrapper());
    }

    private DefaultThreadPool(ChannelWrapper channel) {
        super((Channel)channel);
        this.m_channelWrapper = channel;
    }

    public String getBlockPolicy() {
        return this.m_blockPolicy;
    }

    public int getMaxQueueSize() {
        return this.m_queueSize < 0 ? Integer.MAX_VALUE : this.m_queueSize;
    }

    public int getMaximumQueueSize() {
        return this.m_queueSize;
    }

    public String getName() {
        return this.m_name;
    }

    public int getPriority() {
        return ((ThreadFactory)super.getThreadFactory()).getPriority();
    }

    public int getQueueSize() {
        return this.m_queue.getQueueSize();
    }

    public boolean isQueued() {
        return this.m_queueSize != 0;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void execute(Runnable command) throws InterruptedException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing Command: " + command.toString() + ",pool=" + this.getName());
        }
        super.execute(command);
    }

    public void shutdown() {
        if (this.m_shutdownGraceful) {
            this.shutdownAfterProcessingCurrentlyQueuedTasks();
        } else {
            this.shutdownNow();
        }
        try {
            if (this.getShutdownWaitTimeMs() > 0 && !this.awaitTerminationAfterShutdown(this.getShutdownWaitTimeMs())) {
                this.getLogger().warn("running commands have not terminated within " + this.getShutdownWaitTimeMs() + "ms. Will shut them down by interruption");
                this.interruptAll();
                this.shutdownNow();
            }
            this.awaitTerminationAfterShutdown();
        }
        catch (InterruptedException ie) {
            this.getLogger().error("cannot shutdown ThreadPool", (Throwable)ie);
        }
    }

    void setBlockPolicy(String blockPolicy) {
        this.m_blockPolicy = blockPolicy;
        if ("ABORT".equalsIgnoreCase(blockPolicy)) {
            this.abortWhenBlocked();
        } else if ("DISCARD".equalsIgnoreCase(blockPolicy)) {
            this.discardWhenBlocked();
        } else if ("DISCARDOLDEST".equalsIgnoreCase(blockPolicy)) {
            this.discardOldestWhenBlocked();
        } else if (POLICY_DEFAULT.equalsIgnoreCase(blockPolicy)) {
            this.runWhenBlocked();
        } else if ("WAIT".equalsIgnoreCase(blockPolicy)) {
            this.waitWhenBlocked();
        } else {
            StringBuffer msg = new StringBuffer();
            msg.append("WARNING: Unknown block-policy configuration \"").append(blockPolicy);
            msg.append("\". Should be one of \"").append("ABORT");
            msg.append("\",\"").append("DISCARD");
            msg.append("\",\"").append("DISCARDOLDEST");
            msg.append("\",\"").append(POLICY_DEFAULT);
            msg.append("\",\"").append("WAIT");
            msg.append("\". Will use \"").append(POLICY_DEFAULT).append("\"");
            this.getLogger().warn(msg.toString());
            this.setBlockPolicy(POLICY_DEFAULT);
        }
    }

    void setName(String name) {
        this.m_name = name;
    }

    void setQueue(int queueSize) {
        this.m_queue = queueSize != 0 ? (queueSize > 0 ? new BoundedQueue(queueSize) : new LinkedQueue()) : new SynchronousChannel();
        this.m_queueSize = queueSize;
        this.m_channelWrapper.setChannel(this.m_queue);
    }

    void setShutdownGraceful(boolean shutdownGraceful) {
        this.m_shutdownGraceful = shutdownGraceful;
    }

    boolean isShutdownGraceful() {
        return this.m_shutdownGraceful;
    }

    void setShutdownWaitTimeMs(int shutdownWaitTimeMs) {
        this.m_shutdownWaitTimeMs = shutdownWaitTimeMs;
    }

    int getShutdownWaitTimeMs() {
        return this.m_shutdownWaitTimeMs;
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

