/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.regex.RegexData;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.regex.RegexTranslator;
import net.sf.saxon.regex.SurrogateRegexTranslator;
import net.sf.saxon.value.Whitespace;

public class JDK14RegexTranslator
extends SurrogateRegexTranslator {
    private static final SurrogateRegexTranslator.CharClass[] specialBlockCharClasses = new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.CharRange(66304, 66351), new SurrogateRegexTranslator.CharRange(66352, 66383), new SurrogateRegexTranslator.CharRange(66560, 66639), new SurrogateRegexTranslator.CharRange(118784, 119039), new SurrogateRegexTranslator.CharRange(119040, 119295), new SurrogateRegexTranslator.CharRange(119808, 120831), new SurrogateRegexTranslator.CharRange(131072, 173782), new SurrogateRegexTranslator.CharRange(194560, 195103), new SurrogateRegexTranslator.CharRange(917504, 917631), new Union(new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.CharRange(57344, 63743), new SurrogateRegexTranslator.CharRange(983040, 1048573), new SurrogateRegexTranslator.CharRange(0x100000, 1114109)}), SurrogateRegexTranslator.Empty.getInstance(), SurrogateRegexTranslator.Empty.getInstance(), SurrogateRegexTranslator.Empty.getInstance()};
    private static final SurrogateRegexTranslator.CharClass DOT_SCHEMA = new SurrogateRegexTranslator.Complement(new Union(new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.SingleChar('\n'), new SurrogateRegexTranslator.SingleChar('\r')}));
    private static final SurrogateRegexTranslator.CharClass DOT_XPATH = new SurrogateRegexTranslator.Dot();
    private static final SurrogateRegexTranslator.CharClass ESC_d = new SurrogateRegexTranslator.Property("Nd");
    private static final SurrogateRegexTranslator.CharClass ESC_D = new SurrogateRegexTranslator.Complement(ESC_d);
    private static final SurrogateRegexTranslator.CharClass ESC_W = new Union(new SurrogateRegexTranslator.CharClass[]{JDK14RegexTranslator.computeCategoryCharClass('P'), JDK14RegexTranslator.computeCategoryCharClass('Z'), JDK14RegexTranslator.computeCategoryCharClass('C')});
    private static final SurrogateRegexTranslator.CharClass ESC_w = new SurrogateRegexTranslator.Complement(ESC_W);
    private static final SurrogateRegexTranslator.CharClass ESC_s = new Union(new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.SingleChar(' '), new SurrogateRegexTranslator.SingleChar('\n'), new SurrogateRegexTranslator.SingleChar('\r'), new SurrogateRegexTranslator.SingleChar('\t')});
    private static final SurrogateRegexTranslator.CharClass ESC_S = new SurrogateRegexTranslator.Complement(ESC_s);
    private static final SurrogateRegexTranslator.CharClass ESC_i = JDK14RegexTranslator.makeCharClass("LlLuLoLtNl", ":_\u02bb\u02bc\u02bd\u02be\u02bf\u02c0\u02c1\u0559\u06e5\u06e6\u212e", "\u00aa\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02ad\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u048c\u048f\u04ec\u04ed\u0587\u0587\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07a5\u0950\u0950\u0ad0\u0ad0\u0d85\u0dc6\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u1055\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a8\u207f\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final SurrogateRegexTranslator.CharClass ESC_I = new SurrogateRegexTranslator.Complement(ESC_i);
    private static final SurrogateRegexTranslator.CharClass ESC_c = JDK14RegexTranslator.makeCharClass("LlLuLoLtNlMcMeMnLmNd", "-.:_\u00b7\u0387\u06dd\u212e", "\u00aa\u00b5\u00ba\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02b8\u02e0\u02ee\u0346\u034e\u0362\u037a\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u0488\u048f\u04ec\u04ed\u0587\u0587\u0653\u0655\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07b0\u0950\u0950\u0ad0\u0ad0\u0d82\u0df3\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u0f6a\u0f96\u0f96\u0fae\u0fb0\u0fb8\u0fb8\u0fba\u1059\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a9\u207f\u207f\u20dd\u20e0\u20e2\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u2183\u3006\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final SurrogateRegexTranslator.CharClass ESC_C = new SurrogateRegexTranslator.Complement(ESC_c);

    public void setIgnoreWhitespace(boolean bl) {
        this.ignoreWhitespace = bl;
    }

    public String translate(CharSequence charSequence, boolean bl) throws RegexSyntaxException {
        this.regExp = charSequence;
        this.isXPath = bl;
        this.length = charSequence.length();
        this.advance();
        this.translateTop();
        return this.result.toString();
    }

    protected boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                int n = ++this.currentCapture;
                this.translateRegExp();
                this.expect(')');
                this.captures.add(n);
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.inCharClassExpr = true;
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                if (this.isXPath) {
                    DOT_XPATH.output(this.result);
                    this.advance();
                    return true;
                }
                DOT_SCHEMA.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                if (this.isXPath) {
                    this.copyCurChar();
                    return true;
                }
                this.result.append('\\');
            }
        }
        this.copyCurChar();
        return true;
    }

    private static SurrogateRegexTranslator.CharClass makeCharClass(String string, String string2, String string3) {
        int n;
        int n2;
        ArrayList<SurrogateRegexTranslator.SimpleCharClass> arrayList = new ArrayList<SurrogateRegexTranslator.SimpleCharClass>(5);
        int n3 = string.length();
        for (n2 = 0; n2 < n3; n2 += 2) {
            arrayList.add(new SurrogateRegexTranslator.Property(string.substring(n2, n2 + 2)));
        }
        n3 = string2.length();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2 + 1; n < n3 && string2.charAt(n) - string2.charAt(n2) == n - n2; ++n) {
            }
            if (n2 == --n - 1) {
                --n;
            }
            if (n2 == n) {
                arrayList.add(new SurrogateRegexTranslator.SingleChar(string2.charAt(n2)));
            } else {
                arrayList.add(new SurrogateRegexTranslator.CharRange(string2.charAt(n2), string2.charAt(n)));
            }
            n2 = n;
        }
        ArrayList<SurrogateRegexTranslator.SimpleCharClass> arrayList2 = new ArrayList<SurrogateRegexTranslator.SimpleCharClass>(5);
        n = string3.length();
        for (n3 = 0; n3 < n; n3 += 2) {
            char c;
            char c2 = string3.charAt(n3);
            if (c2 == (c = string3.charAt(n3 + 1))) {
                arrayList2.add(new SurrogateRegexTranslator.SingleChar(c2));
                continue;
            }
            if (c2 == c - '\u0001') {
                arrayList2.add(new SurrogateRegexTranslator.SingleChar(c2));
                arrayList2.add(new SurrogateRegexTranslator.SingleChar(c));
                continue;
            }
            arrayList2.add(new SurrogateRegexTranslator.CharRange(c2, c));
        }
        return new Subtraction(new Union(arrayList), new Union(arrayList2));
    }

    private SurrogateRegexTranslator.CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SurrogateRegexTranslator.SingleChar('\n');
            }
            case 'r': {
                this.advance();
                return new SurrogateRegexTranslator.SingleChar('\r');
            }
            case 't': {
                this.advance();
                return new SurrogateRegexTranslator.SingleChar('\t');
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return ESC_i;
            }
            case 'I': {
                this.advance();
                return ESC_I;
            }
            case 'c': {
                this.advance();
                return ESC_c;
            }
            case 'C': {
                this.advance();
                return ESC_C;
            }
            case 'd': {
                this.advance();
                return ESC_d;
            }
            case 'D': {
                this.advance();
                return ESC_D;
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp();
            }
            case 'P': {
                this.advance();
                return new SurrogateRegexTranslator.Complement(this.parseProp());
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.isXPath) {
                    char c = this.curChar;
                    int n = c - 48;
                    this.advance();
                    int n2 = "0123456789".indexOf(this.curChar);
                    if (n2 >= 0) {
                        int n3 = n * 10 + n2;
                        this.advance();
                        if (this.captures.contains(n3)) {
                            return new SurrogateRegexTranslator.BackReference(n3);
                        }
                        this.recede();
                    }
                    if (this.captures.contains(n)) {
                        return new SurrogateRegexTranslator.BackReference(n);
                    }
                    return new SurrogateRegexTranslator.BackReference(-1);
                }
                throw this.makeException("digit not allowed after \\");
            }
            case '$': {
                if (this.isXPath) break;
            }
            default: {
                throw this.makeException("invalid escape sequence");
            }
        }
        SurrogateRegexTranslator.SingleChar singleChar = new SurrogateRegexTranslator.SingleChar(this.curChar);
        this.advance();
        return singleChar;
    }

    private SurrogateRegexTranslator.CharClass parseProp() throws RegexSyntaxException {
        this.expect('{');
        int n = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (JDK14RegexTranslator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        CharSequence charSequence = this.regExp.subSequence(n, this.pos - 1);
        if (this.ignoreWhitespace && !this.inCharClassExpr) {
            charSequence = Whitespace.removeAllWhitespace(charSequence);
        }
        String string = ((Object)charSequence).toString();
        this.advance();
        switch (string.length()) {
            case 0: {
                throw this.makeException("empty property name");
            }
            case 2: {
                int n2 = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".indexOf(string);
                if (n2 < 0 || n2 % 2 == 1) {
                    throw this.makeException("unknown category");
                }
                return JDK14RegexTranslator.getSubCategoryCharClass(n2 / 2);
            }
            case 1: {
                int n3 = "LMNPZSC".indexOf(string.charAt(0));
                if (n3 < 0) {
                    throw this.makeException("unknown category", string);
                }
                return JDK14RegexTranslator.getCategoryCharClass(n3);
            }
        }
        if (string.startsWith("Is")) {
            String string2 = string.substring(2);
            for (int i = 0; i < RegexData.specialBlockNames.length; ++i) {
                if (!string2.equals(RegexData.specialBlockNames[i])) continue;
                return specialBlockCharClasses[i];
            }
            if (!JDK14RegexTranslator.isBlock(string2)) {
                throw this.makeException("invalid block name", string2);
            }
            return new SurrogateRegexTranslator.Property("In" + string2);
        }
        throw this.makeException("invalid property name", string);
    }

    private SurrogateRegexTranslator.CharClass parseCharClassExpr() throws RegexSyntaxException {
        SurrogateRegexTranslator.CharClass charClass;
        boolean bl;
        if (this.curChar == '^') {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        ArrayList<SurrogateRegexTranslator.CharClass> arrayList = new ArrayList<SurrogateRegexTranslator.CharClass>(10);
        do {
            charClass = this.parseCharClassEscOrXmlChar(true);
            arrayList.add(charClass);
            if (this.curChar == ']' || this.eos) break;
            if (this.curChar != '-') continue;
            char c = this.regExp.charAt(this.pos);
            if (c == '[') {
                this.advance();
                break;
            }
            if (c == ']') continue;
            this.advance();
            SurrogateRegexTranslator.CharClass charClass2 = this.parseCharClassEscOrXmlChar(true);
            if (charClass.getSingleChar() < 0 || charClass2.getSingleChar() < 0) {
                throw this.makeException("multi_range");
            }
            if (charClass.getSingleChar() > charClass2.getSingleChar()) {
                throw this.makeException("invalid range (start > end)");
            }
            arrayList.set(arrayList.size() - 1, new SurrogateRegexTranslator.CharRange(charClass.getSingleChar(), charClass2.getSingleChar()));
            if (this.curChar != '-' || this.regExp.charAt(this.pos) != '[') continue;
            this.advance();
            break;
        } while (this.curChar != ']');
        if (this.eos) {
            this.expect(']');
        }
        charClass = arrayList.size() == 1 ? (SurrogateRegexTranslator.CharClass)arrayList.get(0) : new Union(arrayList);
        if (bl) {
            charClass = new SurrogateRegexTranslator.Complement(charClass);
        }
        if (this.curChar == '[') {
            this.advance();
            charClass = new Subtraction(charClass, this.parseCharClassExpr());
            this.expect(']');
        }
        this.inCharClassExpr = false;
        this.advance();
        return charClass;
    }

    private SurrogateRegexTranslator.CharClass parseCharClassEscOrXmlChar(boolean bl) throws RegexSyntaxException {
        SurrogateRegexTranslator.SimpleCharClass simpleCharClass;
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '[': 
            case ']': {
                throw this.makeException("character must be escaped", new String(new char[]{this.curChar}));
            }
            case '-': {
                if (bl) break;
                throw this.makeException("character must be escaped", new String(new char[]{this.curChar}));
            }
        }
        if (XMLChar.isSurrogate(this.curChar)) {
            if (!XMLChar.isHighSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            char c = this.curChar;
            this.advance();
            if (!XMLChar.isLowSurrogate(this.curChar)) {
                throw this.makeException("invalid surrogate pair");
            }
            simpleCharClass = new SurrogateRegexTranslator.WideSingleChar(XMLChar.supplemental(c, this.curChar));
        } else {
            simpleCharClass = new SurrogateRegexTranslator.SingleChar(this.curChar);
        }
        this.advance();
        return simpleCharClass;
    }

    private static synchronized SurrogateRegexTranslator.CharClass getCategoryCharClass(int n) {
        if (categoryCharClasses[n] == null) {
            JDK14RegexTranslator.categoryCharClasses[n] = JDK14RegexTranslator.computeCategoryCharClass("LMNPZSC".charAt(n));
        }
        return categoryCharClasses[n];
    }

    private static synchronized SurrogateRegexTranslator.CharClass getSubCategoryCharClass(int n) {
        if (subCategoryCharClasses[n] == null) {
            JDK14RegexTranslator.subCategoryCharClasses[n] = JDK14RegexTranslator.computeSubCategoryCharClass("LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".substring(n * 2, (n + 1) * 2));
        }
        return subCategoryCharClasses[n];
    }

    private static SurrogateRegexTranslator.CharClass computeCategoryCharClass(char c) {
        int n;
        ArrayList<SurrogateRegexTranslator.CharClass> arrayList = new ArrayList<SurrogateRegexTranslator.CharClass>(5);
        arrayList.add(new SurrogateRegexTranslator.Property(new String(new char[]{c})));
        int n2 = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(c);
        while (n2 >= 0) {
            int[] nArray = RegexData.CATEGORY_RANGES[n2 / 2];
            for (n = 0; n < nArray.length; n += 2) {
                arrayList.add(new SurrogateRegexTranslator.CharRange(nArray[n], nArray[n + 1]));
            }
            n2 = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(c, n2 + 1);
        }
        if (c == 'P') {
            arrayList.add(JDK14RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039\u00bb\u2019\u201d\u203a"));
        }
        if (c == 'L') {
            arrayList.add(new SurrogateRegexTranslator.SingleChar('\u03f5'));
            arrayList.add(new SurrogateRegexTranslator.SingleChar('\u03f4'));
        }
        if (c == 'C') {
            arrayList.add(new Subtraction(new SurrogateRegexTranslator.Property("Cn"), new Union(new SurrogateRegexTranslator.CharClass[]{new SurrogateRegexTranslator.SingleChar('\u03f4'), new SurrogateRegexTranslator.SingleChar('\u03f5')})));
            ArrayList<SurrogateRegexTranslator.CharRange> arrayList2 = new ArrayList<SurrogateRegexTranslator.CharRange>(5);
            for (int i = 0; i < RegexData.CATEGORY_RANGES.length; ++i) {
                for (n = 0; n < RegexData.CATEGORY_RANGES[i].length; n += 2) {
                    arrayList2.add(new SurrogateRegexTranslator.CharRange(RegexData.CATEGORY_RANGES[i][n], RegexData.CATEGORY_RANGES[i][n + 1]));
                }
            }
            arrayList.add(new Subtraction(new SurrogateRegexTranslator.CharRange(65536, 0x10FFFF), new Union(arrayList2)));
        }
        if (arrayList.size() == 1) {
            return (SurrogateRegexTranslator.CharClass)arrayList.get(0);
        }
        return new Union(arrayList);
    }

    private static SurrogateRegexTranslator.CharClass computeSubCategoryCharClass(String string) {
        SurrogateRegexTranslator.Property property = new SurrogateRegexTranslator.Property(string);
        int n = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(string);
        if (n < 0) {
            if (string.equals("Cn")) {
                ArrayList<SurrogateRegexTranslator.SimpleCharClass> arrayList = new ArrayList<SurrogateRegexTranslator.SimpleCharClass>(5);
                arrayList.add(new SurrogateRegexTranslator.SingleChar('\u03f4'));
                arrayList.add(new SurrogateRegexTranslator.SingleChar('\u03f5'));
                for (int i = 0; i < RegexData.CATEGORY_RANGES.length; ++i) {
                    for (int j = 0; j < RegexData.CATEGORY_RANGES[i].length; j += 2) {
                        arrayList.add(new SurrogateRegexTranslator.CharRange(RegexData.CATEGORY_RANGES[i][j], RegexData.CATEGORY_RANGES[i][j + 1]));
                    }
                }
                return new Subtraction(new Union(new SurrogateRegexTranslator.CharClass[]{property, new SurrogateRegexTranslator.CharRange(65536, 0x10FFFF)}), new Union(arrayList));
            }
            if (string.equals("Pi")) {
                return JDK14RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039");
            }
            if (string.equals("Pf")) {
                return JDK14RegexTranslator.makeCharClass("\u00bb\u2019\u201d\u203a");
            }
            return property;
        }
        ArrayList<SurrogateRegexTranslator.SimpleCharClass> arrayList = new ArrayList<SurrogateRegexTranslator.SimpleCharClass>(5);
        arrayList.add(property);
        int[] nArray = RegexData.CATEGORY_RANGES[n / 2];
        for (int i = 0; i < nArray.length; i += 2) {
            arrayList.add(new SurrogateRegexTranslator.CharRange(nArray[i], nArray[i + 1]));
        }
        if (string.equals("Lu")) {
            arrayList.add(new SurrogateRegexTranslator.SingleChar('\u03f4'));
        } else if (string.equals("Ll")) {
            arrayList.add(new SurrogateRegexTranslator.SingleChar('\u03f5'));
        } else if (string.equals("Nl")) {
            arrayList.add(new SurrogateRegexTranslator.CharRange(5870, 5872));
        } else if (string.equals("No")) {
            return new Subtraction(new Union(arrayList), new SurrogateRegexTranslator.CharRange(5870, 5872));
        }
        return new Union(arrayList);
    }

    private static SurrogateRegexTranslator.CharClass makeCharClass(String string) {
        ArrayList<SurrogateRegexTranslator.SingleChar> arrayList = new ArrayList<SurrogateRegexTranslator.SingleChar>(5);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new SurrogateRegexTranslator.SingleChar(string.charAt(i)));
        }
        return new Union(arrayList);
    }

    public static void main(String[] stringArray) throws RegexSyntaxException {
        String string = new JDK14RegexTranslator().translate(stringArray[0], stringArray[1].equals("xpath"));
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') {
                System.err.print(c);
                continue;
            }
            System.err.print("\\u");
            for (int j = 12; j >= 0; j -= 4) {
                System.err.print("0123456789ABCDEF".charAt(c >> j & 0xF));
            }
        }
        System.err.println();
    }

    static class Union
    extends SurrogateRegexTranslator.CharClass {
        private final List members;

        Union(SurrogateRegexTranslator.CharClass[] charClassArray) {
            this(Union.toList(charClassArray));
        }

        private static List toList(SurrogateRegexTranslator.CharClass[] charClassArray) {
            ArrayList<SurrogateRegexTranslator.CharClass> arrayList = new ArrayList<SurrogateRegexTranslator.CharClass>(5);
            for (int i = 0; i < charClassArray.length; ++i) {
                arrayList.add(charClassArray[i]);
            }
            return arrayList;
        }

        Union(List list) {
            super(Union.computeContainsBmp(list), Union.computeContainsNonBmp(list));
            this.members = list;
        }

        public void outputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            int n = this.members.size();
            for (int i = 0; i < n; ++i) {
                SurrogateRegexTranslator.CharClass charClass = (SurrogateRegexTranslator.CharClass)this.members.get(i);
                if (charClass.getContainsBmp() == -1) continue;
                if (charClass instanceof SurrogateRegexTranslator.SimpleCharClass) {
                    ((SurrogateRegexTranslator.SimpleCharClass)charClass).inClassOutputBmp(fastStringBuffer);
                    continue;
                }
                charClass.outputBmp(fastStringBuffer);
            }
            fastStringBuffer.append(']');
        }

        public void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            SurrogateRegexTranslator.CharClass charClass;
            int n;
            boolean bl = true;
            int n2 = this.members.size();
            for (n = 0; n < n2; ++n) {
                charClass = (SurrogateRegexTranslator.CharClass)this.members.get(n);
                if (charClass.getContainsBmp() == -1 || !(charClass instanceof SurrogateRegexTranslator.SimpleCharClass)) continue;
                if (bl) {
                    fastStringBuffer.append("[^");
                    bl = false;
                }
                ((SurrogateRegexTranslator.SimpleCharClass)charClass).inClassOutputBmp(fastStringBuffer);
            }
            for (n = 0; n < n2; ++n) {
                charClass = (SurrogateRegexTranslator.CharClass)this.members.get(n);
                if (charClass.getContainsBmp() == -1 || charClass instanceof SurrogateRegexTranslator.SimpleCharClass) continue;
                if (bl) {
                    fastStringBuffer.append('[');
                    bl = false;
                } else {
                    fastStringBuffer.append("&&");
                }
                charClass.outputComplementBmp(fastStringBuffer);
            }
            if (bl) {
                fastStringBuffer.append("[\u0000-\uffff]");
            } else {
                fastStringBuffer.append(']');
            }
        }

        public void addNonBmpRanges(List list) {
            int n = this.members.size();
            for (int i = 0; i < n; ++i) {
                ((SurrogateRegexTranslator.CharClass)this.members.get(i)).addNonBmpRanges(list);
            }
        }

        private static int computeContainsBmp(List list) {
            int n = -1;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                n = Math.max(n, ((SurrogateRegexTranslator.CharClass)list.get(i)).getContainsBmp());
            }
            return n;
        }

        private static int computeContainsNonBmp(List list) {
            int n = -1;
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                n = Math.max(n, ((SurrogateRegexTranslator.CharClass)list.get(i)).getContainsNonBmp());
            }
            return n;
        }
    }

    static class Subtraction
    extends SurrogateRegexTranslator.CharClass {
        private final SurrogateRegexTranslator.CharClass cc1;
        private final SurrogateRegexTranslator.CharClass cc2;

        Subtraction(SurrogateRegexTranslator.CharClass charClass, SurrogateRegexTranslator.CharClass charClass2) {
            super(Math.min(charClass.getContainsBmp(), -charClass2.getContainsBmp()), Math.min(charClass.getContainsNonBmp(), -charClass2.getContainsNonBmp()));
            this.cc1 = charClass;
            this.cc2 = charClass2;
        }

        public void outputBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            this.cc1.outputBmp(fastStringBuffer);
            fastStringBuffer.append("&&");
            this.cc2.outputComplementBmp(fastStringBuffer);
            fastStringBuffer.append(']');
        }

        public void outputComplementBmp(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            this.cc1.outputComplementBmp(fastStringBuffer);
            this.cc2.outputBmp(fastStringBuffer);
            fastStringBuffer.append(']');
        }

        public void addNonBmpRanges(List list) {
            ArrayList arrayList = new ArrayList(5);
            this.cc1.addNonBmpRanges(arrayList);
            ArrayList arrayList2 = new ArrayList(5);
            this.cc2.addNonBmpRanges(arrayList2);
            JDK14RegexTranslator.sortRangeList(arrayList);
            JDK14RegexTranslator.sortRangeList(arrayList2);
            Iterator iterator = arrayList2.iterator();
            RegexTranslator.Range range = iterator.hasNext() ? (RegexTranslator.Range)iterator.next() : null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                RegexTranslator.Range range2 = (RegexTranslator.Range)arrayList.get(i);
                while (range != null && range.getMax() < range2.getMin()) {
                    if (iterator.hasNext()) {
                        range = (RegexTranslator.Range)iterator.next();
                        continue;
                    }
                    range = null;
                }
                int n2 = range2.getMin();
                while (range != null && range.getMin() <= range2.getMax()) {
                    if (n2 < range.getMin()) {
                        list.add(new RegexTranslator.Range(n2, range.getMin() - 1));
                    }
                    if ((n2 = range.getMax() + 1) > range2.getMax()) break;
                    if (iterator.hasNext()) {
                        range = (RegexTranslator.Range)iterator.next();
                        continue;
                    }
                    range = null;
                }
                if (n2 > range2.getMax()) continue;
                list.add(new RegexTranslator.Range(n2, range2.getMax()));
            }
        }
    }
}

