/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigInteger;
import net.sf.saxon.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;

public abstract class IntegerValue
extends NumericValue {
    public static final Int64Value MINUS_ONE;
    public static final Int64Value ZERO;
    public static final Int64Value PLUS_ONE;
    public static final Int64Value[] SMALL_INTEGERS;
    public static final Int64Value MAX_LONG;
    public static final Int64Value MIN_LONG;
    private static long NO_LIMIT;
    private static long MAX_UNSIGNED_LONG;
    private static long[] ranges;

    public static IntegerValue makeIntegerValue(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigIntegerValue.MAX_LONG) > 0 || bigInteger.compareTo(BigIntegerValue.MIN_LONG) < 0) {
            return new BigIntegerValue(bigInteger);
        }
        return Int64Value.makeIntegerValue(bigInteger.longValue());
    }

    public abstract ValidationException convertToSubType(AtomicType var1, boolean var2);

    public static boolean checkRange(long l, AtomicType atomicType) {
        for (int i = 0; i < ranges.length; i += 3) {
            if (ranges[i] != (long)atomicType.getFingerprint()) continue;
            long l2 = ranges[i + 1];
            if (l2 != NO_LIMIT && l < l2) {
                return false;
            }
            long l3 = ranges[i + 2];
            return l3 == NO_LIMIT || l3 == MAX_UNSIGNED_LONG || l <= l3;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + atomicType.getDescription());
    }

    public static boolean checkBigRange(BigInteger bigInteger, AtomicType atomicType) {
        for (int i = 0; i < ranges.length; i += 3) {
            if (ranges[i] != (long)atomicType.getFingerprint()) continue;
            long l = ranges[i + 1];
            if (l != NO_LIMIT && BigInteger.valueOf(l).compareTo(bigInteger) > 0) {
                return false;
            }
            long l2 = ranges[i + 2];
            if (l2 == NO_LIMIT) {
                return true;
            }
            if (l2 == MAX_UNSIGNED_LONG) {
                return BigIntegerValue.MAX_UNSIGNED_LONG.compareTo(bigInteger) >= 0;
            }
            return BigInteger.valueOf(l2).compareTo(bigInteger) >= 0;
        }
        throw new IllegalArgumentException("No range information found for integer subtype " + atomicType.getDescription());
    }

    public static AtomicValue stringToInteger(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) <= ' '; ++n2) {
        }
        for (n = n3 - 1; n > n2 && charSequence.charAt(n) <= ' '; --n) {
        }
        if (n2 > n) {
            return IntegerValue.numericError("Cannot convert zero-length string to an integer");
        }
        if (n - n2 < 16) {
            boolean bl = false;
            long l = 0L;
            int n4 = n2;
            if (charSequence.charAt(n4) == '+') {
                ++n4;
            } else if (charSequence.charAt(n4) == '-') {
                bl = true;
                ++n4;
            }
            if (n4 > n) {
                return IntegerValue.numericError("Cannot convert string " + Err.wrap(charSequence, 4) + " to integer: no digits after the sign");
            }
            while (n4 <= n) {
                char c;
                if ((c = charSequence.charAt(n4++)) >= '0' && c <= '9') {
                    l = 10L * l + (long)(c - 48);
                    continue;
                }
                return IntegerValue.numericError("Cannot convert string " + Err.wrap(charSequence, 4) + " to an integer");
            }
            return Int64Value.makeIntegerValue(bl ? -l : l);
        }
        try {
            CharSequence charSequence2 = Whitespace.trimWhitespace(charSequence);
            if (charSequence2.charAt(0) == '+') {
                charSequence2 = charSequence2.subSequence(1, charSequence2.length());
            }
            if (charSequence2.length() < 16) {
                return new Int64Value(Long.parseLong(((Object)charSequence2).toString()));
            }
            return new BigIntegerValue(new BigInteger(((Object)charSequence2).toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return IntegerValue.numericError("Cannot convert string " + Err.wrap(charSequence, 4) + " to an integer");
        }
    }

    private static ValidationErrorValue numericError(String string) {
        ValidationException validationException = new ValidationException(string);
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.INTEGER;
    }

    public boolean isWholeNumber() {
        return true;
    }

    public abstract IntegerValue plus(IntegerValue var1);

    public abstract IntegerValue minus(IntegerValue var1);

    public abstract IntegerValue times(IntegerValue var1);

    public abstract NumericValue div(IntegerValue var1) throws XPathException;

    public abstract IntegerValue mod(IntegerValue var1) throws XPathException;

    public abstract IntegerValue idiv(IntegerValue var1) throws XPathException;

    public abstract BigInteger asBigInteger();

    public Comparable getSchemaComparable() {
        try {
            return this.getDecimalValue();
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    static {
        BuiltInAtomicType.init();
        MINUS_ONE = new Int64Value(-1L);
        ZERO = new Int64Value(0L);
        PLUS_ONE = new Int64Value(1L);
        SMALL_INTEGERS = new Int64Value[]{ZERO, PLUS_ONE, new Int64Value(2L), new Int64Value(3L), new Int64Value(4L), new Int64Value(5L), new Int64Value(6L), new Int64Value(7L), new Int64Value(8L), new Int64Value(9L), new Int64Value(10L), new Int64Value(11L), new Int64Value(12L), new Int64Value(13L), new Int64Value(14L), new Int64Value(15L), new Int64Value(16L), new Int64Value(17L), new Int64Value(18L), new Int64Value(19L), new Int64Value(20L)};
        MAX_LONG = new Int64Value(Long.MAX_VALUE);
        MIN_LONG = new Int64Value(Long.MIN_VALUE);
        NO_LIMIT = -9999L;
        MAX_UNSIGNED_LONG = -9998L;
        ranges = new long[]{532L, NO_LIMIT, NO_LIMIT, 533L, NO_LIMIT, 0L, 534L, NO_LIMIT, -1L, 535L, Long.MIN_VALUE, Long.MAX_VALUE, 536L, Integer.MIN_VALUE, Integer.MAX_VALUE, 537L, -32768L, 32767L, 538L, -128L, 127L, 539L, 0L, NO_LIMIT, 540L, 1L, NO_LIMIT, 541L, 0L, MAX_UNSIGNED_LONG, 542L, 0L, 0xFFFFFFFFL, 543L, 0L, 65535L, 544L, 0L, 255L};
    }
}

