/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.net.MalformedURLException;
import org.tigris.subversion.svnclientadapter.utils.StringUtils;

public class SVNUrl {
    private static final String SVN_PROTOCOL = "svn";
    private static final String SVNSSH_PROTOCOL = "svn+";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String FILE_PROTOCOL = "file";
    protected static final char SEGMENT_SEPARATOR = '/';
    private String protocol;
    private String[] segments;
    private String host;
    private int port;

    public SVNUrl(String svnUrl) throws MalformedURLException {
        if (svnUrl == null) {
            throw new MalformedURLException("Svn url cannot be null. Is this a versioned resource?");
        }
        this.parseUrl(svnUrl.trim());
    }

    private SVNUrl(String protocol, String host, int port, String[] segments) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.segments = segments;
    }

    public SVNUrl appendPath(String path) {
        String[] segmentsToAdd = StringUtils.split(path, '/');
        if (segmentsToAdd.length > 0 && segmentsToAdd[0].equals("")) {
            String[] newSegmentsToAdd = new String[segmentsToAdd.length - 1];
            System.arraycopy(segmentsToAdd, 1, newSegmentsToAdd, 0, segmentsToAdd.length - 1);
            segmentsToAdd = newSegmentsToAdd;
        }
        String[] newSegments = new String[this.segments.length + segmentsToAdd.length];
        System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
        System.arraycopy(segmentsToAdd, 0, newSegments, this.segments.length, segmentsToAdd.length);
        return new SVNUrl(this.protocol, this.host, this.port, newSegments);
    }

    private void parseUrl(String svnUrl) throws MalformedURLException {
        String parsed = svnUrl;
        int i = parsed.indexOf("://");
        if (i == -1) {
            throw new MalformedURLException("Invalid svn url: " + svnUrl);
        }
        this.protocol = parsed.substring(0, i).toLowerCase();
        if (!(this.protocol.equalsIgnoreCase(HTTP_PROTOCOL) || this.protocol.equalsIgnoreCase(HTTPS_PROTOCOL) || this.protocol.equalsIgnoreCase(FILE_PROTOCOL) || this.protocol.equalsIgnoreCase(SVN_PROTOCOL) || this.protocol.startsWith(SVNSSH_PROTOCOL))) {
            throw new MalformedURLException("Invalid svn url: " + svnUrl);
        }
        if ((parsed = parsed.substring(i + 3)).length() == 0) {
            throw new MalformedURLException("Invalid svn url: " + svnUrl);
        }
        i = parsed.indexOf("/");
        if (i == -1) {
            i = parsed.length();
        }
        if (!this.protocol.equalsIgnoreCase(FILE_PROTOCOL)) {
            String hostPort = parsed.substring(0, i).toLowerCase();
            String[] hostportArray = StringUtils.split(hostPort, ':');
            if (hostportArray.length == 0) {
                throw new MalformedURLException("Invalid svn url: " + svnUrl);
            }
            if (hostportArray.length == 2) {
                this.host = hostportArray[0];
                try {
                    this.port = Integer.parseInt(hostportArray[1]);
                }
                catch (NumberFormatException e) {
                    throw new MalformedURLException("Invalid svn url: " + svnUrl);
                }
            } else {
                this.host = hostportArray[0];
                this.port = SVNUrl.getDefaultPort(this.protocol);
            }
        } else {
            this.port = -1;
            this.host = i == 0 ? "" : parsed.substring(0, i);
        }
        parsed = i < parsed.length() ? parsed.substring(i + 1) : "";
        this.segments = StringUtils.split(parsed, '/');
    }

    public static int getDefaultPort(String protocol) {
        int port = -1;
        if (SVN_PROTOCOL.equals(protocol)) {
            port = 3690;
        } else if (HTTP_PROTOCOL.equals(protocol)) {
            port = 80;
        } else if (HTTPS_PROTOCOL.equals(protocol)) {
            port = 443;
        } else if (protocol != null && protocol.startsWith(SVNSSH_PROTOCOL)) {
            port = 22;
        }
        return port;
    }

    private String get() {
        StringBuffer buffer = new StringBuffer(this.calculateUrlLength());
        buffer.append(this.getProtocol());
        buffer.append("://");
        buffer.append(this.getHost());
        if (this.getPort() != SVNUrl.getDefaultPort(this.getProtocol())) {
            buffer.append(":");
            buffer.append(this.getPort());
        }
        for (int i = 0; i < this.segments.length; ++i) {
            buffer.append('/');
            buffer.append(this.segments[i]);
        }
        return buffer.toString();
    }

    private int calculateUrlLength() {
        int result = 3;
        if (this.getProtocol() != null) {
            result += this.getProtocol().length();
        }
        if (this.getHost() != null) {
            result += this.getHost().length();
        }
        if (this.getPort() != SVNUrl.getDefaultPort(this.getProtocol())) {
            ++result;
            result += String.valueOf(this.getPort()).length();
        }
        for (int i = 0; i < this.segments.length; ++i) {
            ++result;
            result += this.segments[i].length();
        }
        return result;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getPathSegments() {
        return this.segments;
    }

    public String getLastPathSegment() {
        if (this.segments.length == 0) {
            return "";
        }
        return this.segments[this.segments.length - 1];
    }

    public SVNUrl getParent() {
        if (this.segments.length == 0 || this.segments.length == 1 && (this.host == null || this.host.length() == 0)) {
            return null;
        }
        String[] parentSegments = new String[this.segments.length - 1];
        System.arraycopy(this.segments, 0, parentSegments, 0, this.segments.length - 1);
        return new SVNUrl(this.protocol, this.host, this.port, parentSegments);
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof SVNUrl)) {
            return false;
        }
        SVNUrl url = (SVNUrl)target;
        return this.get().equals(url.get());
    }

    public int hashCode() {
        return this.get().hashCode();
    }

    public String toString() {
        return this.get();
    }
}

