/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource.ids;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.ids.AbstractDataSourceIdGenerator;
import org.apache.avalon.excalibur.datasource.ids.IdException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class SequenceIdGenerator
extends AbstractDataSourceIdGenerator {
    private String m_query;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BigDecimal getNextBigDecimalIdInner() throws IdException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Requesting an Id using query: " + this.m_query);
        }
        try {
            Connection conn = this.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.m_query);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    BigDecimal bigDecimal = rs.getBigDecimal(1);
                    return bigDecimal;
                }
                String msg = "Query for Id did not return a value";
                this.getLogger().error(msg);
                throw new IdException(msg);
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            String msg = "Unable to allocate an Id";
            this.getLogger().error(msg);
            throw new IdException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getNextLongIdInner() throws IdException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Requesting an Id using query: " + this.m_query);
        }
        try {
            Connection conn = this.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.m_query);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    long l = rs.getLong(1);
                    return l;
                }
                String msg = "Query for Id did not return a value";
                this.getLogger().error(msg);
                throw new IdException(msg);
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            String msg = "Unable to allocate an Id";
            this.getLogger().error(msg);
            throw new IdException(msg, e);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.m_query = configuration.getChild("query").getValue();
    }
}

