/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.KeyDefinition;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.EmptyEnumeration;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.sort.LocalOrderComparer;
import java.util.Hashtable;
import java.util.Vector;

public class KeyManager {
    private Hashtable keyList = new Hashtable();

    public void setKeyDefinition(KeyDefinition keyDefinition) {
        Integer n = new Integer(keyDefinition.getFingerprint());
        Vector<KeyDefinition> vector = (Vector<KeyDefinition>)this.keyList.get(n);
        if (vector == null) {
            vector = new Vector<KeyDefinition>();
            this.keyList.put(n, vector);
        }
        vector.addElement(keyDefinition);
    }

    public Vector getKeyDefinitions(int n) {
        return (Vector)this.keyList.get(new Integer(n));
    }

    private synchronized Hashtable buildIndex(int n, DocumentInfo documentInfo, Controller controller) throws XPathException {
        Vector vector = this.getKeyDefinitions(n);
        if (vector == null) {
            throw new XPathException("Key " + controller.getNamePool().getDisplayName(n) + " has not been defined");
        }
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while (n2 < vector.size()) {
            this.constructIndex(documentInfo, hashtable, (KeyDefinition)vector.elementAt(n2), controller);
            ++n2;
        }
        return hashtable;
    }

    /*
     * Unable to fully structure code
     */
    private void constructIndex(DocumentInfo var1_1, Hashtable var2_2, KeyDefinition var3_3, Controller var4_4) throws XPathException {
        block4: {
            var5_5 = var3_3.getMatch();
            var6_6 = var3_3.getUse();
            var7_7 = var1_1;
            var8_8 = var7_7;
            var9_9 = var4_4.makeContext(var1_1);
            var10_10 = var5_5.getNodeType();
            var11_11 = var1_1.getEnumeration((byte)4, AnyNodeTest.getInstance());
            if (var10_10 != 2 && var10_10 != 0) ** GOTO lbl24
            while (var11_11.hasMoreElements()) {
                var8_8 = var11_11.nextElement();
                if (var8_8.getNodeType() == 1) {
                    var12_12 = var8_8.getEnumeration((byte)2, AnyNodeTest.getInstance());
                    while (var12_12.hasMoreElements()) {
                        this.processKeyNode(var12_12.nextElement(), var5_5, var6_6, var2_2, var9_9);
                    }
                    if (var10_10 != 0) continue;
                    this.processKeyNode(var8_8, var5_5, var6_6, var2_2, var9_9);
                    continue;
                }
                this.processKeyNode(var8_8, var5_5, var6_6, var2_2, var9_9);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var8_8 = var11_11.nextElement();
                this.processKeyNode(var8_8, var5_5, var6_6, var2_2, var9_9);
lbl24:
                // 2 sources

                ** while (var11_11.hasMoreElements())
            }
        }
    }

    private void processKeyNode(NodeInfo nodeInfo, Pattern pattern, Expression expression, Hashtable hashtable, Context context) throws XPathException {
        if (pattern.matches(nodeInfo, context)) {
            context.setContextNode(nodeInfo);
            context.setPosition(1);
            context.setLast(1);
            Value value = expression.evaluate(context);
            if (value instanceof NodeSetValue) {
                context.setContextNode(nodeInfo);
                NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo2 = nodeEnumeration.nextElement();
                    String string = nodeInfo2.getStringValue();
                    NodeSetExtent nodeSetExtent = (NodeSetExtent)hashtable.get(string);
                    if (nodeSetExtent == null) {
                        nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
                        nodeSetExtent.setSorted(true);
                        hashtable.put(string, nodeSetExtent);
                    }
                    nodeSetExtent.append(nodeInfo);
                }
            } else {
                String string = value.asString();
                context.setContextNode(nodeInfo);
                NodeSetExtent nodeSetExtent = (NodeSetExtent)hashtable.get(string);
                if (nodeSetExtent == null) {
                    nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
                    nodeSetExtent.setSorted(true);
                    hashtable.put(string, nodeSetExtent);
                }
                nodeSetExtent.append(nodeInfo);
            }
        }
    }

    public NodeEnumeration selectByKey(int n, DocumentInfo documentInfo, String string, Controller controller) throws XPathException {
        NodeSetExtent nodeSetExtent;
        Hashtable hashtable = documentInfo.getKeyIndex(this, n);
        if (hashtable == null) {
            hashtable = this.buildIndex(n, documentInfo, controller);
            documentInfo.setKeyIndex(this, n, hashtable);
        }
        return (nodeSetExtent = (NodeSetExtent)hashtable.get(string)) == null ? EmptyEnumeration.getInstance() : nodeSetExtent.enumerate();
    }
}

