/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.xpath;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.excalibur.xml.xpath.NodeListImpl;
import org.apache.excalibur.xml.xpath.XPathException;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathUtil {
    public static Node getSingleNode(XPathProcessor processor, Node rootNode, String path) throws XPathException {
        int pos;
        if (path == null) {
            throw new XPathException("XPath is required.");
        }
        if (rootNode == null) {
            return rootNode;
        }
        if (path.length() == 0 || path.equals("/")) {
            return rootNode;
        }
        Node testNode = XPathUtil.searchSingleNode(processor, rootNode, path);
        if (testNode != null) {
            return testNode;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Node parent = rootNode;
        do {
            Node singleNode;
            String nodeName;
            pos = path.indexOf("/");
            int posSelector = path.indexOf("[");
            if (posSelector != -1 && posSelector < pos) {
                posSelector = path.indexOf("]");
                pos = path.indexOf("/", posSelector);
            }
            boolean isAttribute = false;
            if (pos != -1) {
                nodeName = path.substring(0, pos);
                path = path.substring(pos + 1);
            } else {
                nodeName = path;
            }
            if (nodeName.startsWith("@")) {
                isAttribute = true;
            }
            if ((singleNode = XPathUtil.searchSingleNode(processor, parent, nodeName)) == null) {
                Node newNode;
                int posSelect = nodeName.indexOf("[");
                String XPathExp = null;
                if (posSelect != -1) {
                    XPathExp = nodeName.substring(posSelect + 1, nodeName.length() - 1);
                    nodeName = nodeName.substring(0, posSelect);
                }
                if (isAttribute) {
                    try {
                        newNode = rootNode.getOwnerDocument().createAttributeNS(null, nodeName.substring(1));
                    }
                    catch (DOMException local) {
                        throw new XPathException("Unable to create new DOM node: '" + nodeName + "'.", local);
                    }
                }
                try {
                    newNode = rootNode.getOwnerDocument().createElementNS(null, nodeName);
                }
                catch (DOMException local) {
                    throw new XPathException("Unable to create new DOM node: '" + nodeName + "'.", local);
                }
                if (XPathExp != null) {
                    ArrayList<String> attrValuePairs = new ArrayList<String>(4);
                    boolean noError = true;
                    StringTokenizer tokenizer = new StringTokenizer(XPathExp, "= ");
                    while (tokenizer.hasMoreTokens()) {
                        String attr = tokenizer.nextToken();
                        if (attr.startsWith("@")) {
                            if (tokenizer.hasMoreTokens()) {
                                String value = tokenizer.nextToken();
                                if (value.startsWith("'") && value.endsWith("'")) {
                                    value = value.substring(1, value.length() - 1);
                                }
                                if (value.startsWith("\"") && value.endsWith("\"")) {
                                    value = value.substring(1, value.length() - 1);
                                }
                                attrValuePairs.add(attr.substring(1));
                                attrValuePairs.add(value);
                                continue;
                            }
                            noError = false;
                            continue;
                        }
                        if (attr.trim().equals("and")) continue;
                        noError = false;
                    }
                    if (noError) {
                        for (int l = 0; l < attrValuePairs.size(); l += 2) {
                            newNode.setAttributeNS(null, (String)attrValuePairs.get(l), (String)attrValuePairs.get(l + 1));
                        }
                    }
                }
                parent.appendChild(newNode);
                parent = newNode;
                continue;
            }
            parent = singleNode;
        } while (pos != -1);
        return parent;
    }

    public static Node searchSingleNode(XPathProcessor processor, Node contextNode, String str) {
        String[] pathComponents = XPathUtil.buildPathArray(str);
        if (pathComponents == null) {
            return processor.selectSingleNode(contextNode, str);
        }
        return XPathUtil.getFirstNodeFromPath(contextNode, pathComponents, false);
    }

    public static NodeList searchNodeList(XPathProcessor processor, Node contextNode, String str) {
        String[] pathComponents = XPathUtil.buildPathArray(str);
        if (pathComponents == null) {
            return processor.selectNodeList(contextNode, str);
        }
        return XPathUtil.getNodeListFromPath(contextNode, pathComponents);
    }

    public static String[] buildPathArray(String xpath) {
        String[] result = null;
        if (xpath != null && xpath.charAt(0) != '/') {
            int components = 1;
            int l = xpath.length();
            boolean found = false;
            int i = 0;
            block8: while (i < l && !found) {
                switch (xpath.charAt(i)) {
                    case '[': {
                        found = true;
                        continue block8;
                    }
                    case '(': {
                        found = true;
                        continue block8;
                    }
                    case '*': {
                        found = true;
                        continue block8;
                    }
                    case '@': {
                        found = true;
                        continue block8;
                    }
                    case ':': {
                        found = true;
                        continue block8;
                    }
                    case '/': {
                        ++components;
                    }
                }
                ++i;
            }
            if (!found) {
                result = new String[components];
                if (components == 1) {
                    result[components - 1] = xpath;
                } else {
                    int start = 0;
                    components = 0;
                    for (i = 0; i < l; ++i) {
                        if (xpath.charAt(i) != '/') continue;
                        result[components] = xpath.substring(start, i);
                        start = i + 1;
                        ++components;
                    }
                    result[components] = xpath.substring(start);
                }
            }
        }
        return result;
    }

    public static Node getFirstNodeFromPath(Node contextNode, String[] path, boolean create) {
        if (contextNode == null || path == null || path.length == 0) {
            return contextNode;
        }
        Node item = XPathUtil.getFirstNodeFromPath(contextNode, path, 0);
        if (item == null && create) {
            for (int i = 0; contextNode != null && i < path.length; ++i) {
                NodeList childs = contextNode.getChildNodes();
                boolean found = false;
                if (childs != null) {
                    int l = childs.getLength();
                    for (int m = 0; !found && m < l; ++m) {
                        item = childs.item(m);
                        if (item.getNodeType() != 1 || !item.getLocalName().equals(path[i])) continue;
                        found = true;
                        contextNode = item;
                    }
                }
                if (found) continue;
                Element e = contextNode.getOwnerDocument().createElementNS(null, path[i]);
                contextNode.appendChild(e);
                contextNode = e;
            }
            item = contextNode;
        }
        return item;
    }

    private static Node getFirstNodeFromPath(Node contextNode, String[] path, int startIndex) {
        int i = 0;
        Node item = null;
        NodeList childs = contextNode.getChildNodes();
        boolean found = false;
        if (childs != null) {
            i = 0;
            int l = childs.getLength();
            while (!found && i < l) {
                item = childs.item(i);
                if (item.getNodeType() == 1 && path[startIndex].equals(item.getLocalName() != null ? item.getLocalName() : item.getNodeName())) {
                    if (startIndex == path.length - 1) {
                        found = true;
                    } else if ((item = XPathUtil.getFirstNodeFromPath(item, path, startIndex + 1)) != null) {
                        found = true;
                    }
                }
                if (found) continue;
                ++i;
            }
            if (!found) {
                item = null;
            }
        }
        return item;
    }

    public static NodeList getNodeListFromPath(Node contextNode, String[] path) {
        if (contextNode == null) {
            return new NodeListImpl();
        }
        if (path == null || path.length == 0) {
            return new NodeListImpl(new Node[]{contextNode});
        }
        NodeListImpl result = new NodeListImpl();
        try {
            XPathUtil.getNodesFromPath(result, contextNode, path, 0);
        }
        catch (NullPointerException npe) {
            throw new NullPointerException("XMLUtil.getNodeListFromPath() did catch a NullPointerException.This might be due to a missconfigured XML parser which does not use DOM Level 2.Make sure that you use the XML parser shipped with Cocoon.");
        }
        return result;
    }

    private static void getNodesFromPath(NodeListImpl result, Node contextNode, String[] path, int startIndex) {
        block4: {
            NodeList childs;
            block3: {
                childs = contextNode.getChildNodes();
                if (startIndex != path.length - 1) break block3;
                if (childs == null) break block4;
                int l = childs.getLength();
                for (int m = 0; m < l; ++m) {
                    Node item = childs.item(m);
                    if (item.getNodeType() != 1 || !path[startIndex].equals(item.getLocalName() != null ? item.getLocalName() : item.getNodeName())) continue;
                    result.addNode(item);
                }
                break block4;
            }
            if (childs != null) {
                int l = childs.getLength();
                for (int m = 0; m < l; ++m) {
                    Node item = childs.item(m);
                    if (item.getNodeType() != 1 || !path[startIndex].equals(item.getLocalName() != null ? item.getLocalName() : item.getNodeName())) continue;
                    XPathUtil.getNodesFromPath(result, item, path, startIndex + 1);
                }
            }
        }
    }

    public static String getValueOf(XPathProcessor processor, Node root, String path) throws XPathException {
        Node node;
        if (path == null) {
            throw new XPathException("Not a valid XPath: " + path);
        }
        if (root == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((node = XPathUtil.searchSingleNode(processor, root, path)) != null) {
            return XPathUtil.getValueOfNode(processor, node);
        }
        return null;
    }

    public static String getValueOf(XPathProcessor processor, Node root, String path, String defaultValue) throws XPathException {
        String value = XPathUtil.getValueOf(processor, root, path);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getValueAsBooleanOf(XPathProcessor processor, Node root, String path) throws XPathException {
        String value = XPathUtil.getValueOf(processor, root, path);
        if (value == null) {
            throw new XPathException("No such node: " + path);
        }
        return Boolean.valueOf(value);
    }

    public static boolean getValueAsBooleanOf(XPathProcessor processor, Node root, String path, boolean defaultValue) throws XPathException {
        String value = XPathUtil.getValueOf(processor, root, path);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static String getValueOfNode(XPathProcessor processor, Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 2) {
            return node.getNodeValue();
        }
        String value = null;
        node.normalize();
        NodeList childs = node.getChildNodes();
        int i = 0;
        int l = childs.getLength();
        while (i < l && value == null) {
            if (childs.item(i).getNodeType() == 3) {
                value = childs.item(i).getNodeValue().trim();
                continue;
            }
            ++i;
        }
        return value;
    }

    public static String getValueOfNode(XPathProcessor processor, Node node, String defaultValue) {
        String value = XPathUtil.getValueOfNode(processor, node);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

