/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNWinCryptPasswordCipher;

public abstract class SVNPasswordCipher {
    public static final String SIMPLE_CIPHER_TYPE = "simple";
    public static final String WINCRYPT_CIPHER_TYPE = "wincrypt";
    private static final SVNPasswordCipher EMPTY_CIPHER = new CompositePasswordCipher(Collections.EMPTY_LIST, "simple");
    private static final SVNPasswordCipher SIMPLE_CIPHER = new CompositePasswordCipher(Collections.EMPTY_LIST, "simple");
    private static final SVNPasswordCipher WINCRYPT_CIPHER = new SVNWinCryptPasswordCipher();
    private static Map ourInstances = new SVNHashMap();
    private static String ourDefaultType = "simple";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNPasswordCipher getInstance(String type) {
        if (type == null) {
            return EMPTY_CIPHER;
        }
        Map map = ourInstances;
        synchronized (map) {
            if (ourInstances.containsKey(type)) {
                return (SVNPasswordCipher)ourInstances.get(type);
            }
        }
        return EMPTY_CIPHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasCipher(String type) {
        Map map = ourInstances;
        synchronized (map) {
            return type != null && ourInstances.containsKey(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultCipherType(String type) {
        Map map = ourInstances;
        synchronized (map) {
            ourDefaultType = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultCipherType() {
        Map map = ourInstances;
        synchronized (map) {
            if (ourDefaultType != null) {
                return ourDefaultType;
            }
            if (!ourInstances.isEmpty()) {
                ourDefaultType = (String)ourInstances.keySet().iterator().next();
                return ourDefaultType;
            }
        }
        return SIMPLE_CIPHER_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCipher(String type, SVNPasswordCipher cipher) {
        if (type != null && cipher != null) {
            Map map = ourInstances;
            synchronized (map) {
                if (ourInstances.containsKey(type)) {
                    ((CompositePasswordCipher)ourInstances.get(type)).addCipher(cipher);
                } else {
                    cipher = new CompositePasswordCipher(cipher);
                    ourInstances.put(type, cipher);
                }
            }
        }
    }

    protected SVNPasswordCipher() {
    }

    public abstract String encrypt(String var1);

    public abstract String decrypt(String var1);

    public abstract String getCipherType();

    static {
        ourInstances.put(SIMPLE_CIPHER_TYPE, SIMPLE_CIPHER);
        if (SVNWinCryptPasswordCipher.isEnabled()) {
            ourInstances.put(WINCRYPT_CIPHER_TYPE, WINCRYPT_CIPHER);
            ourDefaultType = WINCRYPT_CIPHER_TYPE;
        }
    }

    private static class CompositePasswordCipher
    extends SVNPasswordCipher {
        private List myCiphers;
        private String myCipherType;

        private CompositePasswordCipher(List chiphers, String cipherType) {
            this.myCiphers = chiphers;
            this.myCipherType = cipherType;
        }

        public CompositePasswordCipher(SVNPasswordCipher chipher) {
            this.myCiphers = new ArrayList();
            this.myCiphers.add(chipher);
        }

        public synchronized void addCipher(SVNPasswordCipher chipher) {
            this.myCiphers.add(chipher);
        }

        public synchronized String decrypt(String encyrptedData) {
            Iterator chiphers = this.myCiphers.iterator();
            while (chiphers.hasNext()) {
                SVNPasswordCipher chipher = (SVNPasswordCipher)chiphers.next();
                encyrptedData = chipher.decrypt(encyrptedData);
            }
            return encyrptedData;
        }

        public synchronized String encrypt(String rawData) {
            Iterator chiphers = this.myCiphers.iterator();
            while (chiphers.hasNext()) {
                SVNPasswordCipher chipher = (SVNPasswordCipher)chiphers.next();
                rawData = chipher.encrypt(rawData);
            }
            return rawData;
        }

        public String getCipherType() {
            return this.myCipherType;
        }
    }
}

