/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.event.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.forms.event.ActionEvent;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.util.JavaScriptHelper;
import org.mozilla.javascript.Script;

public abstract class JavaScriptWidgetListener {
    private Script script;
    private Context context;

    public JavaScriptWidgetListener(Script script, Context context) {
        this.script = script;
        this.context = context;
    }

    protected void callScript(WidgetEvent event) {
        try {
            HashMap<String, Object> values = new HashMap<String, Object>(2);
            values.put("event", event);
            Map objectModel = ContextHelper.getObjectModel((Context)this.context);
            Object viewData = FlowHelper.getContextObject((Map)objectModel);
            if (viewData != null) {
                values.put("viewData", viewData);
            }
            JavaScriptHelper.execScript(this.script, values, objectModel);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error invoking JavaScript event handler", (Throwable)e);
        }
    }

    public static class JSValueChangedListener
    extends JavaScriptWidgetListener
    implements ValueChangedListener {
        public JSValueChangedListener(Script script, Context context) {
            super(script, context);
        }

        public void valueChanged(ValueChangedEvent event) {
            super.callScript(event);
        }
    }

    public static class JSActionListener
    extends JavaScriptWidgetListener
    implements ActionListener {
        public JSActionListener(Script script, Context context) {
            super(script, context);
        }

        public void actionPerformed(ActionEvent event) {
            super.callScript(event);
        }
    }
}

