/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.webdav;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavResource;

public class WebDAVUtil {
    private static String staticURI;
    private static WebdavResource staticResource;

    public static synchronized WebdavResource getWebdavResource(String uri) throws HttpException, IOException {
        if (uri == null) {
            return null;
        }
        if (uri.equals(staticURI)) {
            staticResource.discoverOwnLocks();
            return staticResource;
        }
        HttpURL sourceURL = new HttpURL(uri);
        staticURI = uri;
        staticResource = new WebdavResource(sourceURL);
        staticResource.discoverOwnLocks();
        return staticResource;
    }

    public static void createResource(String uri, String content) throws HttpException, IOException {
        String filename = uri.substring(uri.lastIndexOf("/"));
        String uriPrefix = uri.substring(0, uri.lastIndexOf("/") + 1);
        HttpURL sourceURL = new HttpURL(uri);
        WebdavResource resource = WebDAVUtil.getWebdavResource(uriPrefix);
        if (!resource.putMethod(uriPrefix + filename, content)) {
            throw new HttpException("Error creating resource: " + uri + " Status: " + resource.getStatusCode() + " Message: " + resource.getStatusMessage());
        }
    }

    public static void copyResource(String from, String to, boolean recurse, boolean overwrite) throws HttpException, IOException {
        String relativeDestination = to.substring(to.indexOf("://") + 3);
        relativeDestination = relativeDestination.substring(relativeDestination.indexOf("/"));
        if (recurse) {
            WebDAVUtil.makePath(to.substring(0, to.lastIndexOf("/")));
        }
        WebdavResource resource = WebDAVUtil.getWebdavResource(from);
        resource.setOverwrite(overwrite);
        if (!resource.copyMethod(relativeDestination)) {
            throw new HttpException("Error copying resource: " + from + " Status: " + resource.getStatusCode() + " Message: " + resource.getStatusMessage());
        }
    }

    public static void moveResource(String from, String to, boolean recurse, boolean overwrite) throws HttpException, IOException {
        String relativeDestination = to.substring(to.indexOf("://") + 3);
        relativeDestination = relativeDestination.substring(relativeDestination.indexOf("/"));
        if (recurse) {
            WebDAVUtil.makePath(to.substring(0, to.lastIndexOf("/")));
        }
        WebdavResource resource = WebDAVUtil.getWebdavResource(from);
        resource.setOverwrite(overwrite);
        if (!resource.moveMethod(relativeDestination)) {
            throw new HttpException("Error moving resource: " + from + " Status: " + resource.getStatusCode() + " Message: " + resource.getStatusMessage());
        }
    }

    public static void makePath(String path) throws HttpException, IOException {
        String parentPath = path;
        while (true) {
            try {
                HttpURL sourceURL = new HttpURL(parentPath + "/");
                new WebdavResource(sourceURL);
            }
            catch (HttpException he) {
                parentPath = parentPath.substring(0, parentPath.lastIndexOf("/"));
                continue;
            }
            break;
        }
        if (parentPath.length() < path.length()) {
            String pathToMake = path.substring(parentPath.length() + 1) + "/";
            String colToMake = null;
            while (pathToMake.indexOf("/") != -1) {
                colToMake = pathToMake.substring(0, pathToMake.indexOf("/"));
                WebDAVUtil.makeCollection(path.substring(0, path.lastIndexOf(colToMake)), colToMake);
                pathToMake = pathToMake.substring(pathToMake.indexOf("/") + 1);
            }
        }
    }

    public static void makeCollection(String parent, String collection) throws HttpException, IOException {
        WebdavResource parentResource = WebDAVUtil.getWebdavResource(parent);
        parentResource.mkcolMethod(parent + collection + "/");
    }

    public static SourceProperty getProperty(String uri, String name, String namespace) throws HttpException, IOException {
        Vector<PropertyName> propNames = new Vector<PropertyName>(1);
        propNames.add(new PropertyName(namespace, name));
        Enumeration props = null;
        Property prop = null;
        WebdavResource resource = WebDAVUtil.getWebdavResource(uri);
        Enumeration responses = resource.propfindMethod(0, propNames);
        while (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            props = response.getProperties();
            if (!props.hasMoreElements()) continue;
            prop = (Property)props.nextElement();
            return new SourceProperty(prop.getElement());
        }
        return null;
    }

    public static Map getProperties(String uri, Set propNames) throws HttpException, IOException {
        ArrayList<SourceProperty> sourceproperties = new ArrayList<SourceProperty>();
        Enumeration responses = null;
        Enumeration props = null;
        Property prop = null;
        HashMap propertiesMap = new HashMap();
        WebdavResource resource = WebDAVUtil.getWebdavResource(uri);
        responses = resource.propfindMethod(0, new Vector(propNames));
        while (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            props = response.getProperties();
            while (props.hasMoreElements()) {
                prop = (Property)props.nextElement();
                SourceProperty srcProperty = new SourceProperty(prop.getElement());
                sourceproperties.add(srcProperty);
            }
        }
        int i = 0;
        while (i < sourceproperties.size()) {
            propertiesMap.put(((SourceProperty)sourceproperties.get(i)).getNamespace() + ":" + ((SourceProperty)sourceproperties.get(i)).getName(), sourceproperties.get(i));
            ++i;
        }
        return propertiesMap;
    }

    public static List getAllProperties(String uri) throws HttpException, IOException {
        ArrayList<SourceProperty> sourceproperties = new ArrayList<SourceProperty>();
        WebdavResource resource = WebDAVUtil.getWebdavResource(uri);
        Enumeration responses = resource.propfindMethod(0);
        Enumeration props = null;
        Property prop = null;
        while (responses.hasMoreElements()) {
            ResponseEntity response = (ResponseEntity)responses.nextElement();
            props = response.getProperties();
            while (props.hasMoreElements()) {
                prop = (Property)props.nextElement();
                SourceProperty srcProperty = new SourceProperty(prop.getElement());
                sourceproperties.add(srcProperty);
            }
        }
        return sourceproperties;
    }

    public static void setProperty(String uri, String name, String namespace, String value) throws HttpException, IOException {
        WebdavResource resource = WebDAVUtil.getWebdavResource(uri);
        if (!resource.proppatchMethod(new PropertyName(namespace, name), value, true)) {
            throw new HttpException("Error setting property " + namespace + ":" + name + " on resource: " + uri + " Status: " + resource.getStatusCode() + " Message: " + resource.getStatusMessage());
        }
    }

    public static void setProperties(String uri, Map properties) throws HttpException, IOException {
        WebdavResource resource = WebDAVUtil.getWebdavResource(uri);
        if (!resource.proppatchMethod(new Hashtable(properties), true)) {
            throw new HttpException("Error setting properties on resource: " + uri + " Status: " + resource.getStatusCode() + " Message: " + resource.getStatusMessage());
        }
    }
}

