/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.database.Property;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.cocoon.xml.XMLConsumer;

import java.util.Enumeration;

/**
 * A group of SDX users.
 *
 * <p>
 * Groups are used in SDX to implement some user rights
 * management. A group must have at least a name, but it can be backed up
 * by a complex XML file with other kinds of information.
 */
public class Group extends AbstractIdentity {

    /** A character buffer for element content. */
	// FIXME : private field never read locally [MP]
    private StringBuffer characterBuffer;

    /** The current field name */
	// FIXME : private field never read locally [MP]
    private String currentFieldName;

    /** name of the object used in toSAX() methods */
    public final static String NODE_NAME = "group"; //TODO : move to constants -pb


    /**
     * Creates a group without information. The name must be supplied at indexing time.
     */
    public Group() throws SDXException {
        super();
    }

    /**
     * Creates a group given a group id.
     *
     * @param   id        The group id.
     */
    public Group(String id) throws SDXException {
        super(id);
    }

    /**
     * Starts the indexing process. For users, it must return at least a "name" field.
     *
     * <p>
     * Indexing is done in the usual way but at the end we keep specific
     * user information and make them available for the getters.
     *
     * @param   parser      A parser that can be used for the indexing.
     * @param   consumer    The consumer that is the target of the indexing (may be <code>null</code>. The previously provided consumer will then be used) TODO?:what does this mean?-rbp
     */
    public void startIndexing(SAXParser parser, XMLConsumer consumer) throws SDXException {
        // First, call the super method for normal indexing.
        super.startIndexing(parser, consumer);
        // Then keep the relevant information.
        // FIXME : is this code belox used ? [MP]
        Enumeration values = this.getFieldValues();
        if (values != null) {
            // The relevant informations should now be in the field values
            while (values.hasMoreElements()) {
                Property prop = (Property) values.nextElement();
                String name = prop.getName();
//                if (name.equals(ELEMENT_NAME)) setName(prop.getValue());
            }
        }
    }

    /**Gets the docType for the document*/
    public String getDocType() {
        return Document.DOCTYPE_GROUP;
    }

}
