/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.XMLConsumer;

public abstract class AbstractRepository
extends AbstractSdxObject
implements Repository {
    protected boolean isDefault;
    private final String ATTRIBUTE_READ_ONLY = "read-only";

    protected void loadBaseConfiguration(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.isDefault = configuration.getAttributeAsBoolean("default", false);
    }

    public void releaseConnection(RepositoryConnection c) throws SDXException {
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void delete(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        this.checkConnection(c);
    }

    public void add(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        this.checkConnection(c);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        encoding = this.checkEncoding(encoding);
        this.checkConnection(c);
        return null;
    }

    public void get(Document doc, OutputStream os, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        Utilities.checkOutputStream(super.getLog(), os);
        this.checkConnection(c);
    }

    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        Utilities.checkXmlConsumer(super.getLog(), consumer);
        this.checkConnection(c);
    }

    public void setIsDefault(boolean b) {
        this.isDefault = b;
    }

    protected String checkEncoding(String encoding) throws SDXException {
        String defaultEncoding = "UTF-8";
        if (Utilities.checkString(encoding)) {
            try {
                defaultEncoding.getBytes(encoding);
                return encoding;
            }
            catch (UnsupportedEncodingException e) {
                LoggingUtils.logException(super.getLog(), e);
                try {
                    defaultEncoding.getBytes(defaultEncoding);
                    LoggingUtils.logInfo(super.getLog(), "Using the default encoding: " + defaultEncoding);
                    return defaultEncoding;
                }
                catch (UnsupportedEncodingException e1) {
                    String[] args = new String[]{defaultEncoding, e1.getMessage()};
                    throw new SDXException(super.getLog(), 217, args, null);
                }
            }
        }
        return defaultEncoding;
    }

    public void checkConnection(RepositoryConnection c) throws SDXException {
        if (c == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 3005, args, null);
        }
    }

    public void optimize() throws SDXException {
    }

    protected String getClassNameSuffix() {
        return "Repository";
    }
}

