/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.AbstractDatabaseBackedRepository;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.repository.URLRepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;

public class URLRepository
extends AbstractDatabaseBackedRepository {
    private boolean checkOnGet = false;
    private boolean useCache = false;
    private URL baseURL = null;
    private Repository cacheRepository = null;
    private static String URL_PROPERTY = "url";
    private static String TIME_PROPERTY = "time";
    private static String IS_RELATIVE_PROPERTY = "relative";
    private final String ATTRIBUTE_BASE = "base";
    private final String ELEMENT_CACHE = "cache";
    private final String ELEMENT_REPOSITORY = "repository";
    private final String ATTRIBUTE_CHECK = "check";
    private String ATTRIBUTE_VALUE_ON_GET = "onGet";
    private Boolean pathIsRelative;

    public void releaseConnection(RepositoryConnection c) throws SDXException {
        super.releaseConnection(c);
        if (this.useCache) {
            this.cacheRepository.releaseConnection(c);
        }
    }

    public RepositoryConnection getConnection() throws SDXException {
        if (this.useCache) {
            return this.cacheRepository.getConnection();
        }
        URLRepositoryConnection conn = new URLRepositoryConnection();
        conn.enableLogging(super.getLog());
        return conn;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            Configuration cacheConf;
            this.loadBaseConfiguration(configuration);
            String base = configuration.getAttribute("base", null);
            if (Utilities.checkString(base)) {
                if (base.startsWith("http://")) {
                    if (!base.endsWith("/")) {
                        base = base + "/";
                    }
                    this.baseURL = new URL(base);
                } else {
                    File baseFile = Utilities.resolveFile(null, configuration.getLocation(), (Context)super.getContext(), base, false);
                    this.baseURL = baseFile.toURI().toURL();
                }
            }
            if ((cacheConf = configuration.getChild("cache", false)) != null) {
                Configuration cacheRepoConf;
                this.useCache = true;
                String check = cacheConf.getAttribute("check", this.ATTRIBUTE_VALUE_ON_GET);
                if (check.equalsIgnoreCase(this.ATTRIBUTE_VALUE_ON_GET)) {
                    this.checkOnGet = true;
                }
                if ((cacheRepoConf = cacheConf.getChild("repository", false)) == null) {
                    String[] args = new String[]{cacheConf.getLocation()};
                    SDXException sdxE = new SDXException(super.getLog(), 20, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
                }
                String ref = cacheRepoConf.getAttribute("ref", null);
                if (Utilities.checkString(ref)) {
                    Context appRepos = (Context)super.getContext().get((Object)"sdx.application.repos");
                    if (appRepos != null) {
                        this.cacheRepository = (Repository)appRepos.get((Object)ref);
                    }
                    if (this.cacheRepository == null) {
                        String[] args = new String[]{ref};
                        throw new SDXException(super.getLog(), 29, args, null);
                    }
                } else {
                    this.cacheRepository = ConfigurationUtils.createRepository(super.getLog(), (Context)super.getContext(), super.getServiceManager(), cacheRepoConf);
                }
            }
        }
        catch (ConfigurationException e) {
            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
            throw e;
        }
        catch (MalformedURLException e) {
            LoggingUtils.logException(super.getLog(), e);
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public void init() throws SDXException {
        super.init();
    }

    public long size() throws SDXException {
        return this._database.size();
    }

    public long size(int type) throws SDXException {
        return this._database.size();
    }

    public void lists(ContentHandler hdl) throws SDXException {
    }

    public synchronized void add(Document doc, RepositoryConnection c) throws SDXException {
        super.add(doc, c);
        String docId = doc.getId();
        String docUrl = this.getURL(doc);
        long now = new Date().getTime();
        if (Utilities.checkString(docUrl)) {
            if (this.useCache) {
                this.cacheRepository.add(doc, c);
            }
            DatabaseEntity de = new DatabaseEntity(docId);
            de.addProperty(URL_PROPERTY, docUrl);
            de.addProperty(TIME_PROPERTY, new Long(now).toString());
            de.addProperty(IS_RELATIVE_PROPERTY, this.pathIsRelative.toString());
            if (this._database != null) {
                this._database.update(de);
            }
        }
    }

    public synchronized void empty() throws SDXException {
        if (this.useCache) {
            this.cacheRepository.empty();
        }
        if (this._database != null) {
            this._database.empty();
        }
    }

    public synchronized void delete(Document doc, RepositoryConnection c) throws SDXException {
        super.delete(doc, c);
        if (this.useCache) {
            this.cacheRepository.delete(doc, c);
        }
        if (this._database != null) {
            this._database.delete(new DatabaseEntity(doc.getId()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection c) throws SDXException {
        super.toSAX(doc, consumer, c);
        SAXParser parser = null;
        ServiceManager l_manager = super.getServiceManager();
        try {
            try {
                doc.setContent(this.openStream(doc, null, c));
                parser = (SAXParser)l_manager.lookup(SAXParser.ROLE);
                doc.parse(parser, consumer);
            }
            catch (ServiceException e) {
                String[] args = new String[]{e.getMessage()};
                SDXException sdxE = new SDXException(null, 2001, args, e);
                String[] args2 = new String[]{this.getId(), sdxE.getMessage()};
                throw new SDXException(super.getLog(), 3001, args2, (Throwable)((Object)sdxE));
            }
            Object var11_6 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            if (parser == null) throw throwable;
            l_manager.release(parser);
            throw throwable;
        }
        l_manager.release((Object)parser);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        super.openStream(doc, encoding, c);
        return this.openStream(doc);
    }

    public void get(Document doc, OutputStream os, RepositoryConnection c) throws SDXException {
        super.get(doc, os, c);
        try {
            InputStream is = this.openStream(doc);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3001, args, e);
        }
    }

    private URL getURL(Boolean isRelative, String u) throws MalformedURLException, IOException {
        if (isRelative.booleanValue()) {
            return new URL(this.baseURL, u);
        }
        return new URL(u);
    }

    private InputStream openStream(Document doc) throws SDXException {
        DatabaseEntity de = null;
        if (this._database != null) {
            de = this._database.getEntity(doc.getId());
        }
        if (de == null) {
            String[] args = new String[]{doc.getId(), this.getId()};
            throw new SDXException(super.getLog(), 3002, args, null);
        }
        if (this.useCache) {
            RepositoryConnection conn = this.cacheRepository.getConnection();
            InputStream is = this.cacheRepository.openStream(doc, null, conn);
            this.cacheRepository.releaseConnection(conn);
            return is;
        }
        try {
            URL docURL = this.getURL(Boolean.valueOf(de.getProperty(IS_RELATIVE_PROPERTY)), de.getProperty(URL_PROPERTY));
            return docURL.openStream();
        }
        catch (MalformedURLException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3001, args, e);
        }
        catch (IOException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3001, args, e);
        }
    }

    private String getURL(Document doc) throws SDXException {
        URL docURL = doc.getURL();
        if (docURL != null) {
            if (this.baseURL == null) {
                this.pathIsRelative = new Boolean(false);
                return docURL.toExternalForm();
            }
            return this.compareURL(docURL);
        }
        return null;
    }

    private String compareURL(URL docURL) {
        String rootFilePath = docURL.toExternalForm().substring(0, this.baseURL.toExternalForm().length());
        if (rootFilePath.equals(this.baseURL.toExternalForm())) {
            this.pathIsRelative = new Boolean(true);
            return docURL.toExternalForm().substring(this.baseURL.toExternalForm().length());
        }
        this.pathIsRelative = new Boolean(false);
        return docURL.toExternalForm();
    }

    public void optimize() throws SDXException {
        super.optimize();
        if (this.useCache) {
            this.cacheRepository.optimize();
        }
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        if (this.baseURL != null) {
            this._xmlizable_objects.put("Base_URL", this.baseURL.toString());
        } else {
            this._xmlizable_objects.put("Base_URL", "none");
        }
        this._xmlizable_objects.put("Check_On_Get", String.valueOf(this.checkOnGet));
        this._xmlizable_objects.put("Use_cache", String.valueOf(this.useCache));
        this._xmlizable_objects.put("Cache_Repository", this.cacheRepository);
        if (this.pathIsRelative != null) {
            this._xmlizable_objects.put("Path_Is_Relative", this.pathIsRelative.toString());
        }
        return true;
    }

    protected void initVolatileObjectsToSax() {
        super.initVolatileObjectsToSax();
        if (this.baseURL != null) {
            this._xmlizable_objects.put("Base_URL", this.baseURL.toString());
        } else {
            this._xmlizable_objects.put("Base_URL", "null");
        }
        this._xmlizable_objects.put("Use_cache", String.valueOf(this.useCache));
        this._xmlizable_objects.put("Check_On_Get", String.valueOf(this.checkOnGet));
        if (this.pathIsRelative != null) {
            this._xmlizable_objects.put("Path_Is_Relative", this.pathIsRelative.toString());
        }
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "URL");
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
    }
}

