/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.DateFilter;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.filter.Criteria;
import fr.gouv.culture.sdx.search.lucene.filter.Filter;
import fr.gouv.culture.sdx.search.lucene.query.AbstractQuery;
import fr.gouv.culture.sdx.search.lucene.query.SDXRangeQuery;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import java.util.Date;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DateIntervalQuery
extends AbstractQuery {
    private Field field;
    private Date _beginDate;
    private Date _endDate;
    protected boolean _inclusive = true;

    public void setUpOai(SearchLocations sLocs, String fieldName, Date beginDate, Date endDate) throws SDXException {
        super.setSearchLocations(sLocs);
        Field field = this.searchLocations.getField(fieldName);
        if (field == null) {
            String[] args = new String[]{fieldName};
            throw new SDXException(super.getLog(), 4001, args, null);
        }
        if (field.getFieldType() != 2) {
            String[] args = new String[]{fieldName};
            throw new SDXException(super.getLog(), 4106, args, null);
        }
        this.field = field;
        if (beginDate == null && endDate == null) {
            throw new SDXException(super.getLog(), 4107, null, null);
        }
        this._beginDate = beginDate;
        this._endDate = endDate;
        this.luceneQuery = new TermQuery(new Term("sdxall", "1"));
        DateFilter f = beginDate == null ? DateFilter.Before(field.getCode(), endDate) : (endDate == null ? DateFilter.After(field.getCode(), beginDate) : new DateFilter(field.getCode(), beginDate, endDate));
        Criteria c = new Criteria();
        c.enableLogging(super.getLog());
        c.setUp(f);
        Filter filt = new Filter();
        filt.setUp(1);
        filt.add(c);
        this.addFilter(filt);
    }

    public void setUp(SearchLocations sLocs, String fieldName, Date beginDate, Date endDate) throws SDXException {
        this.setUp(sLocs, fieldName, beginDate, endDate, this._inclusive);
    }

    public void setUp(SearchLocations sLocs, String fieldName, Date beginDate, Date endDate, boolean inclusive) throws SDXException {
        super.setSearchLocations(sLocs);
        Field field = this.searchLocations.getField(fieldName);
        if (field == null) {
            String[] args = new String[]{fieldName};
            throw new SDXException(super.getLog(), 4001, args, null);
        }
        if (field.getFieldType() != 2) {
            String[] args = new String[]{fieldName};
            throw new SDXException(super.getLog(), 4106, args, null);
        }
        this.field = field;
        if (beginDate == null && endDate == null) {
            throw new SDXException(super.getLog(), 4107, null, null);
        }
        this._beginDate = beginDate;
        this._endDate = endDate;
        String lowerBound = DateField.MIN_DATE_STRING();
        String upperBound = DateField.MAX_DATE_STRING();
        if (beginDate != null) {
            lowerBound = DateField.dateToString(this._beginDate);
        }
        if (endDate != null) {
            upperBound = DateField.dateToString(this._endDate);
        }
        this.setLuceneRangeQuery(fieldName, lowerBound, upperBound, inclusive);
    }

    protected void setLuceneRangeQuery(String fieldName, String lowerBound, String upperBound, boolean inclusive) {
        this.luceneQuery = new SDXRangeQuery(new Term(fieldName, lowerBound), new Term(fieldName, upperBound), inclusive);
    }

    public void toSAX(ContentHandler hdl) throws SAXException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "query";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "type", "CDATA", "dateInterval");
        atts.addAttribute("", "engine", "engine", "CDATA", "lucene");
        try {
            atts.addAttribute("", "luceneQuery", "luceneQuery", "CDATA", this.luceneQuery.toString(this.searchLocations.getDefaultField().getCode()));
        }
        catch (SDXException sdxE) {
            throw new SAXException(sdxE.getMessage(), (Exception)((Object)sdxE));
        }
        atts.addAttribute("", "field", "field", "CDATA", this.field.getCode());
        if (this._beginDate != null) {
            atts.addAttribute("", "from", "from", "CDATA", fr.gouv.culture.sdx.utils.Date.formatDate(this._beginDate));
        }
        if (this._endDate != null) {
            atts.addAttribute("", "to", "to", "CDATA", fr.gouv.culture.sdx.utils.Date.formatDate(this._endDate));
        }
        hdl.startElement(sdxNsUri, localName, qName, atts);
        this.getSearchLocations().toSAX(hdl);
        if (this.filter != null) {
            this.filter.toSAX(hdl);
        }
        if (this.baseQuery != null) {
            String bqLocalName = "baseQuery";
            String bqQName = sdxNsPrefix + ":" + bqLocalName;
            AttributesImpl emptyAtts = new AttributesImpl();
            hdl.startElement(sdxNsUri, bqLocalName, bqQName, emptyAtts);
            this.baseQuery.toSAX(hdl);
            hdl.endElement(sdxNsUri, bqLocalName, bqQName);
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }
}

