/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.database.JDBCDatabase;
import fr.gouv.culture.sdx.utils.save.SaveParameters;

public class POSTGRESQLDatabase
extends JDBCDatabase {
    protected final String FIELD_KEY = "sdx_key";

    protected String getTableCreationQuery() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE TABLE ").append(this.getTableName());
        buffer.append(" ( ").append("id").append(" VARCHAR(255) NOT NULL,");
        buffer.append("propertyName").append(" VARCHAR(255) NOT NULL, ");
        buffer.append("propertyValue").append(" VARCHAR(255) NOT NULL, ");
        buffer.append("sdx_key").append(" SERIAL, ");
        buffer.append("PRIMARY KEY (").append("sdx_key").append("))");
        return buffer.toString();
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("Database_Type", "POSTGRESQLDatabase");
        this._xmlizable_objects.put("JDBC_Table_Name", this.tableName);
        this._xmlizable_objects.put("Data_Source_Identifier", this.dsi);
        return true;
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "POSTGRESQL");
        }
    }

    protected String getCreateIndiciesQuery(String fieldName) {
        return "CREATE INDEX " + this.getTableName() + '_' + fieldName + "_idx" + " ON " + this.getTableName() + " (" + fieldName + ")";
    }

    protected String getEntriesWithLimitQuery(long offset, long number) {
        String query = "SELECT * FROM " + this.getTableName();
        query = query + " LIMIT " + String.valueOf(number) + " OFFSET " + String.valueOf(offset) + ";";
        return query;
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
    }
}

