/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.sitemap.PatternException;

public class CallFunctionNode
extends AbstractProcessingNode
implements Configurable,
Composable {
    protected List parameters;
    protected VariableResolver functionName;
    protected VariableResolver continuationId;
    protected ComponentManager manager;
    protected Interpreter interpreter;

    public static List resolveList(List expressions, ComponentManager manager, InvokeContext context, Map objectModel) throws PatternException {
        int size;
        if (expressions == null || (size = expressions.size()) == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Interpreter.Argument> result = new ArrayList<Interpreter.Argument>(size);
        for (int i = 0; i < size; ++i) {
            Interpreter.Argument arg = (Interpreter.Argument)expressions.get(i);
            String value = VariableResolverFactory.getResolver(arg.value, manager).resolve(context, objectModel);
            result.add(new Interpreter.Argument(arg.name, value));
        }
        return result;
    }

    public CallFunctionNode(VariableResolver functionName, VariableResolver continuationId) {
        this.functionName = functionName;
        this.continuationId = continuationId;
    }

    public void setInterpreter(Interpreter interp) throws Exception {
        this.interpreter = interp;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.parameters = new ArrayList();
        Configuration[] params = config.getChildren("parameter");
        for (int i = 0; i < params.length; ++i) {
            Configuration param = params[i];
            String name = param.getAttribute("name", null);
            String value = param.getAttribute("value", null);
            this.parameters.add(new Interpreter.Argument(name, value));
        }
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public boolean invoke(Environment env, InvokeContext context) throws Exception {
        List params = null;
        if (this.parameters != null) {
            params = CallFunctionNode.resolveList(this.parameters, this.manager, context, env.getObjectModel());
        }
        Redirector redirector = context.getRedirector();
        String continuation = this.continuationId.resolve(context, env.getObjectModel());
        if (continuation != null && continuation.length() > 0) {
            try {
                this.interpreter.handleContinuation(continuation, params, redirector);
            }
            catch (Exception e) {
                throw ProcessingException.throwLocated("Sitemap: error calling continuation", (Throwable)e, this.getLocation());
            }
            if (!redirector.hasRedirected()) {
                throw new ProcessingException("Sitemap: <map:call continuation> did not send a response", this.getLocation());
            }
            return true;
        }
        String name = this.functionName.resolve(context, env.getObjectModel());
        if (name != null && name.length() > 0) {
            try {
                this.interpreter.callFunction(name, params, redirector);
            }
            catch (Exception e) {
                throw ProcessingException.throwLocated("Sitemap: error calling function '" + name + "'", (Throwable)e, this.getLocation());
            }
            if (!redirector.hasRedirected()) {
                throw new ProcessingException("Sitemap: <map:call function> did not send a response", this.getLocation());
            }
            return true;
        }
        throw new ProcessingException("Sitemap: no function nor continuation given in <map:call function>", this.getLocation());
    }
}

