/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.log;

import java.util.Map;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.location.LocatedException;
import org.apache.cocoon.util.log.ExtensiblePatternFormatter;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.Logger;

public class CocoonLogFormatter
extends ExtensiblePatternFormatter {
    public static final int DEFAULT_STACK_DEPTH = 8;
    protected static final int TYPE_CLASS = 9;
    protected static final int TYPE_URI = 10;
    protected static final int TYPE_THREAD = 11;
    protected static final int TYPE_HOST = 12;
    protected static final int TYPE_QUERY = 13;
    protected static final int TYPE_ROOTTHROWABLE = 14;
    protected static final String TYPE_CLASS_STR = "class";
    protected static final String TYPE_CLASS_SHORT_STR = "short";
    protected static final String TYPE_URI_STR = "uri";
    protected static final String TYPE_THREAD_STR = "thread";
    protected static final String TYPE_HOST_STR = "host";
    protected static final String TYPE_QUERY_STR = "query";
    protected static final String TYPE_ROOTTHROWABLE_STR = "rootThrowable";
    private static final String DEFAULT_TIME_PATTERN = "(yyyy-MM-dd) HH:mm.ss:SSS";
    private static final FastDateFormat dateFormatter = FastDateFormat.getInstance((String)"(yyyy-MM-dd) HH:mm.ss:SSS");
    private final Class logkitClass = LogKitLogger.class;
    private final Class loggerClass = Logger.class;
    private CallStack callStack;

    public CocoonLogFormatter() {
        this(8);
    }

    public CocoonLogFormatter(int stackDepth) {
        try {
            this.callStack = new CallStack();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_CLASS_STR)) {
            return 9;
        }
        if (type.equalsIgnoreCase(TYPE_URI_STR)) {
            return 10;
        }
        if (type.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 11;
        }
        if (type.equalsIgnoreCase(TYPE_HOST_STR)) {
            return 12;
        }
        if (type.equalsIgnoreCase(TYPE_QUERY_STR)) {
            return 13;
        }
        if (type.equalsIgnoreCase(TYPE_ROOTTHROWABLE_STR)) {
            return 14;
        }
        return super.getTypeIdFor(type);
    }

    protected String formatPatternRun(LogEvent event, ExtensiblePatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getClass(run.m_format);
            }
            case 10: {
                return this.getURI(event.getContextMap());
            }
            case 11: {
                return this.getThread(event.getContextMap());
            }
            case 12: {
                return this.getHost(event.getContextMap());
            }
            case 13: {
                return this.getQueryString(event.getContextMap());
            }
            case 14: {
                Throwable thr = event.getThrowable();
                Throwable root = ExceptionUtils.getRootCause((Throwable)thr);
                return this.getStackTrace(root == null ? thr : root, run.m_format);
            }
        }
        return super.formatPatternRun(event, run);
    }

    private String getClass(String format) {
        if (this.callStack != null) {
            Class[] stack = this.callStack.get();
            for (int i = stack.length - 1; i >= 0; --i) {
                if (!this.logkitClass.isAssignableFrom(stack[i]) && !this.loggerClass.isAssignableFrom(stack[i])) continue;
                String className = stack[i + 1].getName();
                if (TYPE_CLASS_SHORT_STR.equalsIgnoreCase(format)) {
                    className = ClassUtils.getShortClassName((String)className);
                }
                return className;
            }
        }
        return "Unknown-Class";
    }

    private String getURI(ContextMap ctxMap) {
        Request request;
        Object context;
        if (ctxMap != null && (context = ctxMap.get("objectModel")) != null && context instanceof Map && (request = ObjectModelHelper.getRequest((Map)context)) != null) {
            return request.getRequestURI();
        }
        return "Unknown-URI";
    }

    private String getQueryString(ContextMap ctxMap) {
        String queryString;
        Request request;
        Object context;
        if (ctxMap != null && (context = ctxMap.get("objectModel")) != null && context instanceof Map && (request = ObjectModelHelper.getRequest((Map)context)) != null && (queryString = request.getQueryString()) != null) {
            return "?" + queryString;
        }
        return "";
    }

    private String getHost(ContextMap ctxMap) {
        Request request;
        Object context;
        if (ctxMap != null && (context = ctxMap.get("objectModel")) != null && context instanceof Map && (request = ObjectModelHelper.getRequest((Map)context)) != null) {
            return request.getHeader(TYPE_HOST_STR);
        }
        return "Unknown-Host";
    }

    private String getThread(ContextMap ctxMap) {
        String threadName;
        if (ctxMap != null && (threadName = (String)ctxMap.get("threadName")) != null) {
            return threadName;
        }
        return "Unknown-Thread";
    }

    protected String getStackTrace(Throwable throwable, String format) {
        if (throwable != null) {
            LocatedException.ensureCauseChainIsSet(throwable);
            return ExceptionUtils.getStackTrace((Throwable)throwable);
        }
        return null;
    }

    protected String getTime(long time, String pattern) {
        if (pattern == null || DEFAULT_TIME_PATTERN.equals(pattern)) {
            return dateFormatter.format(time);
        }
        return FastDateFormat.getInstance((String)pattern).format(time);
    }

    static class CallStack
    extends SecurityManager {
        CallStack() {
        }

        public Class[] get() {
            return this.getClassContext();
        }
    }
}

