/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.decorator;

import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.excalibur.logger.decorator.LoggerManagerDecorator;
import org.apache.avalon.excalibur.logger.util.LoggerUtil;
import org.apache.avalon.framework.logger.Logger;

public class PrefixDecorator
extends LoggerManagerDecorator
implements LoggerManager {
    private final String m_prefix;

    public PrefixDecorator(LoggerManager loggerManager, String prefix) {
        super(loggerManager);
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        if ("".equals(prefix)) {
            throw new IllegalArgumentException("prefix can't be empty");
        }
        this.m_prefix = prefix;
    }

    public Logger getLoggerForCategory(String categoryName) {
        String fullCategoryName = LoggerUtil.getFullCategoryName(this.m_prefix, categoryName);
        return this.m_loggerManager.getLoggerForCategory(fullCategoryName);
    }

    public Logger getDefaultLogger() {
        String fullCategoryName = LoggerUtil.getFullCategoryName(this.m_prefix, null);
        return this.m_loggerManager.getLoggerForCategory(fullCategoryName);
    }
}

