/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentableException;
import org.apache.excalibur.instrument.manager.http.AbstractHTMLHandler;
import org.apache.excalibur.instrument.manager.http.server.HTTPRedirect;

public class HTMLInstrumentableHandler
extends AbstractHTMLHandler {
    public HTMLInstrumentableHandler(DefaultInstrumentManager manager) {
        super("/instrumentable.html", manager);
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        InstrumentDescriptor[] instruments;
        InstrumentableDescriptor desc;
        String name = this.getParameter(parameters, "name");
        try {
            desc = this.getInstrumentManager().locateInstrumentableDescriptor(name);
        }
        catch (NoSuchInstrumentableException e) {
            int pos = name.lastIndexOf(46);
            if (pos >= 0) {
                throw new HTTPRedirect("instrumentable.html?name=" + this.urlEncode(name.substring(0, pos)));
            }
            throw new HTTPRedirect("instrument-manager.html");
        }
        out.println("<html>");
        out.println("<head><title>" + desc.getDescription() + "</title></head>");
        out.println("<body>");
        this.breadCrumbs(out, desc, false);
        out.println("<h2>Instrumentable</h2>");
        this.startTable(out);
        this.tableRow(out, 0, "Name", desc.getName());
        this.tableRow(out, 0, "Description", desc.getDescription());
        this.endTable(out);
        InstrumentableDescriptor[] instrumentables = desc.getChildInstrumentableDescriptors();
        if (instrumentables.length > 0) {
            out.println("<h2>Instrumentables</h2>");
            this.outputInstrumentables(out, instrumentables);
        }
        if ((instruments = desc.getInstrumentDescriptors()).length > 0) {
            out.println("<h2>Instruments</h2>");
            this.outputInstruments(out, instruments);
        }
        this.footer(out);
        out.println("</body>");
        out.println("</html>");
    }
}

