/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.auth.acting;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.auth.ApplicationUtil;
import org.apache.cocoon.auth.User;
import org.apache.cocoon.auth.acting.AbstractAuthAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public final class LoggedInAction
extends AbstractAuthAction {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters par) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN act resolver=" + resolver + ", objectModel=" + objectModel + ", source=" + source + ", par=" + par);
        }
        HashMap<String, Object> map = null;
        String applicationName = par.getParameter("application");
        String roleName = par.getParameter("role", null);
        boolean negate = par.getParameterAsBoolean("negate-result", false);
        if (this.applicationManager.isLoggedIn(applicationName)) {
            User user = ApplicationUtil.getUser(objectModel);
            if ((roleName == null || user.isUserInRole(roleName)) && !negate) {
                map = new HashMap<String, Object>();
                map.put("ID", user.getId());
                Iterator i = user.getAttributeNames();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    map.put(key, user.getAttribute(key));
                }
            }
        } else if (negate) {
            map = EMPTY_MAP;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END act map={}");
        }
        return map;
    }
}

