/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.StringCollator;

public class CollationMap
implements Serializable {
    private Configuration config;
    private String defaultCollationName;
    private HashMap map;

    public CollationMap(Configuration configuration) {
        this.config = configuration;
        this.defaultCollationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    public CollationMap(CollationMap collationMap) {
        if (collationMap.map != null) {
            this.map = new HashMap(collationMap.map);
        }
        this.config = collationMap.config;
        this.defaultCollationName = collationMap.defaultCollationName;
    }

    public void setDefaultCollationName(String string) {
        this.defaultCollationName = string;
    }

    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public StringCollator getDefaultCollation() {
        return this.getNamedCollation(this.defaultCollationName);
    }

    public void setNamedCollation(String string, StringCollator stringCollator) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(string, stringCollator);
    }

    public StringCollator getNamedCollation(String string) {
        StringCollator stringCollator;
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        if (this.map != null && (stringCollator = (StringCollator)this.map.get(string)) != null) {
            return stringCollator;
        }
        return this.config.getCollationURIResolver().resolve(string, null, this.config);
    }
}

