/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class ValueTailIterator
implements SequenceIterator,
GroundedIterator,
LookaheadIterator {
    private Value baseValue;
    private int start;
    private int pos = 0;

    public ValueTailIterator(Value value, int n) throws XPathException {
        this.baseValue = value;
        this.start = n;
        this.pos = 0;
    }

    public Item next() throws XPathException {
        return this.baseValue.itemAt(this.start + this.pos++);
    }

    public Item current() {
        try {
            return this.baseValue.itemAt(this.start + this.pos - 1);
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    public int position() {
        return this.pos;
    }

    public boolean hasNext() {
        try {
            return this.baseValue.itemAt(this.start + this.pos) != null;
        }
        catch (XPathException xPathException) {
            return true;
        }
    }

    public SequenceIterator getAnother() throws XPathException {
        return new ValueTailIterator(this.baseValue, this.start);
    }

    public Value materialize() throws XPathException {
        if (this.start == 0) {
            return this.baseValue.reduce();
        }
        if (this.baseValue instanceof SequenceExtent) {
            return new SequenceExtent((SequenceExtent)this.baseValue, this.start, this.baseValue.getLength() - this.start);
        }
        return Value.asValue(SequenceExtent.makeSequenceExtent(this.getAnother()));
    }

    public int getProperties() {
        return 5;
    }
}

