/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public abstract class ParentNodeConstructor
extends Instruction {
    protected Expression content;
    private boolean lazyConstruction = false;
    private boolean namespaceSensitiveType;
    int validation = 3;
    private SchemaType schemaType;
    private String baseURI;

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setLazyConstruction(boolean bl) {
        this.lazyConstruction = bl;
    }

    public final boolean isLazyConstruction() {
        return this.lazyConstruction;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
        this.namespaceSensitiveType = schemaType instanceof SimpleType && ((SimpleType)schemaType).isNamespaceSensitive();
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public boolean isNamespaceSensitive() {
        return this.namespaceSensitiveType;
    }

    public void setValidationMode(int n) {
        this.validation = n;
    }

    public int getValidationMode() {
        return this.validation;
    }

    public void setContentExpression(Expression expression) {
        this.content = expression;
        this.adoptChildExpression(expression);
    }

    public Expression getContentExpression() {
        return this.content;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.content = this.content.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.content = this.content.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.content);
        this.verifyLazyConstruction();
        this.checkContentForAttributes(staticContext);
        return this;
    }

    protected abstract void checkContentForAttributes(StaticContext var1) throws XPathException;

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.content = this.content.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.content);
        return this;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (promotionOffer.action != 13) {
            this.content = this.doPromotion(this.content, promotionOffer);
        }
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.content);
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        if (this.content == expression) {
            this.content = expression2;
            bl = true;
        }
        return bl;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public int getCardinality() {
        return 16384;
    }

    void verifyLazyConstruction() {
        if (!this.isLazyConstruction()) {
            return;
        }
        if ((this.getDependencies() & 0xC) != 0) {
            this.setLazyConstruction(false);
        }
        if (this.validation == 1 || this.validation == 2 || this.schemaType != null) {
            this.setLazyConstruction(false);
        }
    }
}

