/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.quartz.utils.ConnectionProvider;

public class DataSourceComponentConnectionProvider
implements ConnectionProvider {
    private ServiceManager m_manager;
    private ServiceSelector m_datasources;
    private DataSourceComponent m_ds;

    public DataSourceComponentConnectionProvider(String dsName, ServiceManager manager) throws ConfigurationException {
        this.m_manager = manager;
        try {
            this.m_datasources = (ServiceSelector)this.m_manager.lookup(DataSourceComponent.ROLE + "Selector");
            this.m_ds = (DataSourceComponent)this.m_datasources.select((Object)dsName);
        }
        catch (ServiceException e) {
            throw new ConfigurationException("No datasource available by that name: " + dsName);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.m_ds.getConnection();
    }

    public void shutdown() throws SQLException {
        if (this.m_ds != null) {
            this.m_datasources.release((Object)this.m_ds);
        }
        if (this.m_datasources != null) {
            this.m_manager.release((Object)this.m_datasources);
        }
        this.m_ds = null;
        this.m_datasources = null;
        this.m_manager = null;
    }
}

