/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.KeyManager;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.tinytree.TinyAttributeImpl;
import com.icl.saxon.tinytree.TinyCommentImpl;
import com.icl.saxon.tinytree.TinyElementImpl;
import com.icl.saxon.tinytree.TinyNamespaceImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;
import com.icl.saxon.tinytree.TinyParentNodeImpl;
import com.icl.saxon.tinytree.TinyProcInstImpl;
import com.icl.saxon.tinytree.TinyTextImpl;
import com.icl.saxon.tree.LineNumberMap;
import com.icl.saxon.tree.SystemIdMap;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

public final class TinyDocumentImpl
extends TinyParentNodeImpl
implements DocumentInfo,
Document {
    private Hashtable idTable = null;
    private NamePool namePool;
    private Hashtable elementList = null;
    private boolean usesNamespaces = false;
    private Hashtable entityTable = null;
    protected char[] charBuffer = new char[4000];
    protected int charBufferLength = 0;
    protected StringBuffer commentBuffer = new StringBuffer(500);
    protected int numberOfNodes = 0;
    protected int lastLevelOneNode = -1;
    protected byte[] nodeType = new byte[4000];
    protected short[] depth = new short[4000];
    protected int[] next = new int[4000];
    protected int[] offset = new int[4000];
    protected int[] length = new int[4000];
    protected int[] nameCode = new int[4000];
    protected int[] prior = null;
    protected int numberOfAttributes = 0;
    protected int[] attParent = new int[100];
    protected int[] attCode = new int[100];
    protected String[] attValue = new String[100];
    protected int numberOfNamespaces = 0;
    protected int[] namespaceParent = new int[20];
    protected int[] namespaceCode = new int[20];
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = new SystemIdMap();
    private Object[] index = new Object[30];
    private int indexEntriesUsed = 0;

    public TinyDocumentImpl() {
        this.nodeNr = 0;
        this.document = this;
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
        this.addNamespace(0, namePool.getNamespaceCode("xml", "http://www.w3.org/XML/1998/namespace"));
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    protected void ensureNodeCapacity() {
        if (this.nodeType.length < this.numberOfNodes + 1) {
            int n = this.numberOfNodes * 2;
            byte[] byArray = new byte[n];
            int[] nArray = new int[n];
            short[] sArray = new short[n];
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            System.arraycopy(this.nodeType, 0, byArray, 0, this.numberOfNodes);
            System.arraycopy(this.next, 0, nArray, 0, this.numberOfNodes);
            System.arraycopy(this.depth, 0, sArray, 0, this.numberOfNodes);
            System.arraycopy(this.offset, 0, nArray2, 0, this.numberOfNodes);
            System.arraycopy(this.length, 0, nArray3, 0, this.numberOfNodes);
            System.arraycopy(this.nameCode, 0, nArray4, 0, this.numberOfNodes);
            this.nodeType = byArray;
            this.next = nArray;
            this.depth = sArray;
            this.offset = nArray2;
            this.length = nArray3;
            this.nameCode = nArray4;
        }
    }

    protected void ensureAttributeCapacity() {
        if (this.attParent.length < this.numberOfAttributes + 1) {
            int n = this.numberOfAttributes * 2;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            String[] stringArray = new String[n];
            System.arraycopy(this.attParent, 0, nArray, 0, this.numberOfAttributes);
            System.arraycopy(this.attCode, 0, nArray2, 0, this.numberOfAttributes);
            System.arraycopy(this.attValue, 0, stringArray, 0, this.numberOfAttributes);
            this.attParent = nArray;
            this.attCode = nArray2;
            this.attValue = stringArray;
        }
    }

    protected void ensureNamespaceCapacity() {
        if (this.namespaceParent.length < this.numberOfNamespaces + 1) {
            int n = this.numberOfNamespaces * 2;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            System.arraycopy(this.namespaceParent, 0, nArray, 0, this.numberOfNamespaces);
            System.arraycopy(this.namespaceCode, 0, nArray2, 0, this.numberOfNamespaces);
            this.namespaceParent = nArray;
            this.namespaceCode = nArray2;
        }
    }

    protected void addNode(short s, int n, int n2, int n3, int n4) {
        this.ensureNodeCapacity();
        this.nodeType[this.numberOfNodes] = (byte)s;
        this.depth[this.numberOfNodes] = (short)n;
        this.offset[this.numberOfNodes] = n2;
        this.length[this.numberOfNodes] = n3;
        this.nameCode[this.numberOfNodes] = n4;
        this.next[this.numberOfNodes] = -1;
        if (n == 1) {
            this.lastLevelOneNode = this.numberOfNodes;
        }
        ++this.numberOfNodes;
    }

    protected void appendChars(char[] cArray, int n, int n2) {
        while (this.charBuffer.length < this.charBufferLength + n2) {
            char[] cArray2 = new char[this.charBuffer.length * 2];
            System.arraycopy(this.charBuffer, 0, cArray2, 0, this.charBufferLength);
            this.charBuffer = cArray2;
        }
        System.arraycopy(cArray, n, this.charBuffer, this.charBufferLength, n2);
        this.charBufferLength += n2;
    }

    protected void truncate(int n) {
        if (n == this.numberOfNodes) {
            return;
        }
        int n2 = n;
        while (n2 < this.numberOfNodes) {
            if (this.nodeType[n2] == 3) {
                this.charBufferLength = this.offset[n2];
                break;
            }
            ++n2;
        }
        int n3 = n;
        while (n3 < this.numberOfNodes) {
            if (this.nodeType[n3] == 1 && this.offset[n3] >= 0) {
                this.numberOfAttributes = this.offset[n3];
                break;
            }
            ++n3;
        }
        int n4 = n;
        while (n4 < this.numberOfNodes) {
            if (this.nodeType[n4] == 1 && this.length[n4] >= 0) {
                this.numberOfNamespaces = this.length[n4];
                break;
            }
            ++n4;
        }
        this.numberOfNodes = n;
        this.nodeType[n] = 9;
        this.depth[n] = 0;
    }

    protected void ensurePriorIndex() {
        if (this.prior == null) {
            this.makePriorIndex();
        }
    }

    private synchronized void makePriorIndex() {
        this.prior = new int[this.numberOfNodes];
        int n = 0;
        while (n < this.numberOfNodes) {
            this.prior[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.numberOfNodes) {
            int n3 = this.next[n2];
            if (n3 != -1) {
                this.prior[n3] = n2;
            }
            ++n2;
        }
    }

    protected void addAttribute(int n, int n2, String string, String string2) {
        this.ensureAttributeCapacity();
        this.attParent[this.numberOfAttributes] = n;
        this.attCode[this.numberOfAttributes] = n2;
        this.attValue[this.numberOfAttributes] = string2;
        ++this.numberOfAttributes;
        if (string.equals("ID")) {
            if (this.idTable == null) {
                this.idTable = new Hashtable();
            }
            TinyNodeImpl tinyNodeImpl = this.getNode(n);
            this.registerID(tinyNodeImpl, string2);
        }
    }

    protected void addNamespace(int n, int n2) {
        this.usesNamespaces = true;
        this.ensureNamespaceCapacity();
        this.namespaceParent[this.numberOfNamespaces] = n;
        this.namespaceCode[this.numberOfNamespaces] = n2;
        ++this.numberOfNamespaces;
    }

    public TinyNodeImpl getNode(int n) {
        switch ((short)this.nodeType[n]) {
            case 9: {
                return this;
            }
            case 1: {
                return new TinyElementImpl(this, n);
            }
            case 3: {
                return new TinyTextImpl(this, n);
            }
            case 8: {
                return new TinyCommentImpl(this, n);
            }
            case 7: {
                return new TinyProcInstImpl(this, n);
            }
        }
        return null;
    }

    public long getSequenceNumber() {
        return 0L;
    }

    protected TinyAttributeImpl getAttributeNode(int n) {
        return new TinyAttributeImpl(this, n);
    }

    protected boolean isUsingNamespaces() {
        return this.usesNamespaces;
    }

    protected TinyNamespaceImpl getNamespaceNode(int n) {
        return new TinyNamespaceImpl(this, n);
    }

    public void setSystemId(String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(this.nodeNr, string);
    }

    public String getSystemId() {
        return this.systemIdMap.getSystemId(this.nodeNr);
    }

    public String getBaseURI() {
        return this.getSystemId();
    }

    protected void setSystemId(int n, String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(n, string);
    }

    protected String getSystemId(int n) {
        return this.systemIdMap.getSystemId(n);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(0, 0);
    }

    protected void setLineNumber(int n, int n2) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n, n2);
        }
    }

    protected int getLineNumber(int n) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n);
        }
        return -1;
    }

    public int getLineNumber() {
        return 0;
    }

    public final short getNodeType() {
        return 9;
    }

    public NodeInfo getParent() {
        return null;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public String generateId() {
        return "";
    }

    protected AxisEnumeration getAllElements(int n) {
        NodeSetExtent nodeSetExtent;
        Integer n2 = new Integer(n);
        if (this.elementList == null) {
            this.elementList = new Hashtable();
        }
        if ((nodeSetExtent = (NodeSetExtent)this.elementList.get(n2)) == null) {
            nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
            nodeSetExtent.setSorted(true);
            int n3 = 1;
            while (n3 < this.numberOfNodes) {
                if (this.nodeType[n3] == 1 && (this.nameCode[n3] & 0xFFFFF) == n) {
                    nodeSetExtent.append(this.getNode(n3));
                }
                ++n3;
            }
            this.elementList.put(n2, nodeSetExtent);
        }
        return (AxisEnumeration)nodeSetExtent.enumerate();
    }

    private void registerID(NodeInfo nodeInfo, String string) {
        NodeInfo nodeInfo2 = (NodeInfo)this.idTable.get(string);
        if (nodeInfo2 == null) {
            this.idTable.put(string, nodeInfo);
        }
    }

    public NodeInfo selectID(String string) {
        if (this.idTable == null) {
            return null;
        }
        return (NodeInfo)this.idTable.get(string);
    }

    public synchronized Hashtable getKeyIndex(KeyManager keyManager, int n) {
        int n2 = 0;
        while (n2 < this.indexEntriesUsed) {
            if ((KeyManager)this.index[n2] == keyManager && (Integer)this.index[n2 + 1] == n) {
                Object object = this.index[n2 + 2];
                return (Hashtable)this.index[n2 + 2];
            }
            n2 += 3;
        }
        return null;
    }

    public synchronized void setKeyIndex(KeyManager keyManager, int n, Hashtable hashtable) {
        int n2 = 0;
        while (n2 < this.indexEntriesUsed) {
            if ((KeyManager)this.index[n2] == keyManager && (Integer)this.index[n2 + 1] == n) {
                this.index[n2 + 2] = hashtable;
                return;
            }
            n2 += 3;
        }
        if (this.indexEntriesUsed + 3 >= this.index.length) {
            Object[] objectArray = new Object[this.indexEntriesUsed * 2];
            System.arraycopy(this.index, 0, objectArray, 0, this.indexEntriesUsed);
            this.index = objectArray;
        }
        this.index[this.indexEntriesUsed++] = keyManager;
        this.index[this.indexEntriesUsed++] = new Integer(n);
        this.index[this.indexEntriesUsed++] = hashtable;
    }

    protected void setUnparsedEntity(String string, String string2) {
        if (this.entityTable == null) {
            this.entityTable = new Hashtable();
        }
        this.entityTable.put(string, string2);
    }

    public String getUnparsedEntity(String string) {
        if (this.entityTable == null) {
            return "";
        }
        String string2 = (String)this.entityTable.get(string);
        return string2 == null ? "" : string2;
    }

    public void copy(Outputter outputter) throws TransformerException {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)3, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            axisEnumeration.nextElement().copy(outputter);
        }
    }

    public void diagnosticDump() {
        System.err.println("Node\ttype\tdepth\toffset\tlength");
        int n = 0;
        while (n < this.numberOfNodes) {
            System.err.println(n + "\t" + this.nodeType[n] + "\t" + this.depth[n] + "\t" + this.offset[n] + "\t" + this.length[n] + "\t" + Navigator.getPath(this.getNode(n)));
            ++n;
        }
    }
}

